/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Map;
import ognl.MemberAccess;

public final class DefaultMemberAccess
implements MemberAccess {
    private final boolean allowPrivateAccess;
    private final boolean allowProtectedAccess;
    private final boolean allowPackageProtectedAccess;

    public DefaultMemberAccess(boolean allowAllAccess) {
        this(allowAllAccess, allowAllAccess, allowAllAccess);
    }

    public DefaultMemberAccess(boolean allowPrivateAccess, boolean allowProtectedAccess, boolean allowPackageProtectedAccess) {
        this.allowPrivateAccess = allowPrivateAccess;
        this.allowProtectedAccess = allowProtectedAccess;
        this.allowPackageProtectedAccess = allowPackageProtectedAccess;
    }

    public Object setup(Map context, Object target, Member member, String propertyName) {
        AccessibleObject accessible;
        Boolean result = null;
        if (this.isAccessible(context, target, member, propertyName) && !(accessible = (AccessibleObject)((Object)member)).isAccessible()) {
            result = Boolean.FALSE;
            accessible.setAccessible(true);
        }
        return result;
    }

    public void restore(Map context, Object target, Member member, String propertyName, Object state) {
        if (state != null) {
            AccessibleObject accessible = (AccessibleObject)((Object)member);
            Boolean stateboolean = (Boolean)state;
            if (!stateboolean.booleanValue()) {
                accessible.setAccessible(false);
            } else {
                throw new IllegalArgumentException("Improper restore state [" + stateboolean + "] for target [" + target + "], member [" + member + "], propertyName [" + propertyName + "]");
            }
        }
    }

    public boolean isAccessible(Map context, Object target, Member member, String propertyName) {
        int modifiers = member.getModifiers();
        boolean result = Modifier.isPublic(modifiers);
        if (!result) {
            result = Modifier.isPrivate(modifiers) ? this.isAllowPrivateAccess() : (Modifier.isProtected(modifiers) ? this.isAllowProtectedAccess() : this.isAllowPackageProtectedAccess());
        }
        return result;
    }

    public boolean isAllowPrivateAccess() {
        return this.allowPrivateAccess;
    }

    public boolean isAllowProtectedAccess() {
        return this.allowProtectedAccess;
    }

    public boolean isAllowPackageProtectedAccess() {
        return this.allowPackageProtectedAccess;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultMemberAccess)) {
            return false;
        }
        DefaultMemberAccess other = (DefaultMemberAccess)o;
        if (this.isAllowPrivateAccess() != other.isAllowPrivateAccess()) {
            return false;
        }
        if (this.isAllowProtectedAccess() != other.isAllowProtectedAccess()) {
            return false;
        }
        return this.isAllowPackageProtectedAccess() == other.isAllowPackageProtectedAccess();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllowPrivateAccess() ? 79 : 97);
        result = result * 59 + (this.isAllowProtectedAccess() ? 79 : 97);
        result = result * 59 + (this.isAllowPackageProtectedAccess() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "DefaultMemberAccess(allowPrivateAccess=" + this.isAllowPrivateAccess() + ", allowProtectedAccess=" + this.isAllowProtectedAccess() + ", allowPackageProtectedAccess=" + this.isAllowPackageProtectedAccess() + ")";
    }
}

