/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.n3r.eql.base.ExpressionEvaluator;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.util.HostAddress;
import org.n3r.eql.util.Logs;
import org.n3r.eql.util.S;
import org.slf4j.Logger;

public class EqlUtils {
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static Pattern endWithWhere = Pattern.compile("\\bWHERE$");
    static Pattern endWithAnd = Pattern.compile("\\bAND$");
    static Pattern endWithOr = Pattern.compile("\\bOR$");

    public static String expandUserHome(String path) {
        if (path.startsWith("~")) {
            return USER_HOME + path.substring(1);
        }
        return path;
    }

    public static void compatibleWithUserToUsername(Map<String, String> params) {
        if (params.containsKey("username")) {
            return;
        }
        if (params.containsKey("user")) {
            params.put("username", params.get("user"));
        }
    }

    public static String getDriverNameFromConnection(DataSource dataSource) {
        String string;
        block6: {
            Connection connection = dataSource.getConnection();
            try {
                string = connection.getMetaData().getDriverName();
                if (Collections.singletonList(connection).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(connection).get(0) != null) {
                    connection.close();
                }
                throw throwable;
            }
            connection.close();
        }
        return string;
    }

    public static String getJdbcUrlFromConnection(DataSource dataSource) {
        String string;
        block6: {
            Connection connection = dataSource.getConnection();
            try {
                string = connection.getMetaData().getURL();
                if (Collections.singletonList(connection).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(connection).get(0) != null) {
                    connection.close();
                }
                throw throwable;
            }
            connection.close();
        }
        return string;
    }

    public static Map<String, Object> newExecContext(Object[] originParams, Object[] dynamics) {
        HashMap execContext = Maps.newHashMap();
        execContext.put("_time", new Timestamp(System.currentTimeMillis()));
        execContext.put("_date", new Date());
        execContext.put("_host", HostAddress.getHost());
        execContext.put("_ip", HostAddress.getIp());
        execContext.put("_results", Lists.newArrayList());
        execContext.put("_lastResult", "");
        Object[] params = EqlUtils.convertParams(originParams);
        execContext.put("_params", params);
        if (params != null) {
            execContext.put("_paramsCount", params.length);
            for (int i = 0; i < params.length; ++i) {
                execContext.put("_" + (i + 1), params[i]);
            }
        }
        execContext.put("_dynamics", dynamics);
        if (dynamics != null) {
            execContext.put("_dynamicsCount", dynamics.length);
        }
        return execContext;
    }

    private static Object[] convertParams(Object[] originParams) {
        if (originParams == null) {
            return null;
        }
        Object[] objects = new Object[originParams.length];
        for (int i = 0; i < originParams.length; ++i) {
            objects[i] = EqlUtils.convertParam(originParams[i]);
        }
        return objects;
    }

    private static Object convertParam(Object originParam) {
        if (originParam instanceof List) {
            return originParam;
        }
        if (originParam instanceof Iterable) {
            return Lists.newArrayList((Iterable)((Iterable)originParam));
        }
        return originParam;
    }

    public static String trimLastUnusedPart(String sql) {
        String returnSql = S.trimRight(sql);
        String upper = S.upperCase(returnSql);
        if (endWithWhere.matcher(upper).find()) {
            return S.trimRight(returnSql.substring(0, returnSql.length() - "WHERE".length()));
        }
        if (endWithAnd.matcher(upper).find()) {
            return S.trimRight(returnSql.substring(0, returnSql.length() - "AND".length()));
        }
        if (endWithOr.matcher(upper).find()) {
            return S.trimRight(returnSql.substring(0, returnSql.length() - "OR".length()));
        }
        return returnSql;
    }

    public static PreparedStatement prepareSQL(String sqlClassPath, EqlConfig eqlConfig, EqlRun eqlRun, String sqlId, String tagSqlId) {
        Logger log = Logs.createLogger(eqlConfig, sqlClassPath, sqlId, tagSqlId, "prepare");
        log.debug(eqlRun.getPrintSql());
        Connection conn = eqlRun.getConnection();
        String sql = eqlRun.getRunSql();
        boolean procedure = eqlRun.getSqlType().isProcedure();
        PreparedStatement ps = procedure ? conn.prepareCall(sql) : conn.prepareStatement(sql);
        EqlUtils.setQueryTimeout(eqlConfig, ps);
        return ps;
    }

    public static int getConfigInt(EqlConfig eqlConfig, String key, int defaultValue) {
        String configValue = eqlConfig.getStr(key);
        if (S.isBlank(configValue)) {
            return defaultValue;
        }
        if (configValue.matches("\\d+")) {
            return Integer.parseInt(configValue);
        }
        return defaultValue;
    }

    public static void setQueryTimeout(EqlConfig eqlConfig, Statement stmt) {
        int queryTimeout = EqlUtils.getConfigInt(eqlConfig, "query.timeout.seconds", 60);
        if (queryTimeout <= 0) {
            queryTimeout = 60;
        }
        try {
            stmt.setQueryTimeout(queryTimeout);
        }
        catch (Exception exception) {}
    }

    public static Iterable<?> evalCollection(String collectionExpr, EqlRun eqlRun) {
        ExpressionEvaluator evaluator = eqlRun.getEqlConfig().getExpressionEvaluator();
        Object value = evaluator.eval(collectionExpr, eqlRun);
        if (value == null) {
            return null;
        }
        if (value instanceof Iterable) {
            return (Iterable)value;
        }
        if (value.getClass().isArray()) {
            return Lists.newArrayList((Object[])((Object[])value));
        }
        if (value instanceof Map) {
            return ((Map)value).entrySet();
        }
        throw new RuntimeException(collectionExpr + " in " + eqlRun.getParamBean() + " is not an expression of a collection");
    }

    public static String collectionExprString(String collectionExpr, EqlRun eqlRun) {
        ExpressionEvaluator evaluator = eqlRun.getEqlConfig().getExpressionEvaluator();
        Object value = evaluator.eval(collectionExpr, eqlRun);
        if (value == null) {
            return null;
        }
        if (value instanceof Iterable || value.getClass().isArray()) {
            return collectionExpr;
        }
        if (value instanceof Map) {
            return collectionExpr + ".entrySet().toArray()";
        }
        throw new RuntimeException(collectionExpr + " in " + eqlRun.getParamBean() + " is not an expression of a collection");
    }

    public static boolean isConstraintViolation(Exception e) {
        return e instanceof SQLException && ((SQLException)e).getSQLState().startsWith("23");
    }
}

