/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class PairsParser {
    /*
     * Enabled aggressive block sorting
     */
    public Map<String, String> parse(String str) {
        HashMap results = Maps.newHashMap();
        char[] chars = str.toCharArray();
        State state = State.None;
        StringBuilder key = new StringBuilder();
        StringBuilder val = new StringBuilder();
        char quoted = '\u0000';
        boolean escaped = false;
        block6: for (char ch : chars) {
            if (!escaped && ch == '\\') {
                escaped = true;
                continue;
            }
            switch (state) {
                case None: {
                    if (Character.isWhitespace(ch)) continue block6;
                    state = State.Key;
                    key.append(ch);
                    break;
                }
                case Key: {
                    if (ch == '=') {
                        state = State.ValueStart;
                        break;
                    }
                    key.append(ch);
                    break;
                }
                case ValueStart: {
                    if (Character.isWhitespace(ch)) continue block6;
                    if ('\'' == ch || '\"' == ch) {
                        quoted = ch;
                        state = State.Value;
                        break;
                    }
                    state = State.Value;
                    val.append(ch);
                    break;
                }
                case Value: {
                    if (!escaped && (quoted == ch || quoted == '\u0000' && Character.isWhitespace(ch))) {
                        state = State.None;
                        results.put(key.toString().trim(), quoted == '\u0000' ? val.toString().trim() : val.toString());
                        key.delete(0, key.length());
                        val.delete(0, val.length());
                        quoted = '\u0000';
                        break;
                    }
                    val.append(ch);
                }
            }
            escaped = false;
        }
        if (state == State.Value) {
            results.put(key.toString().trim(), quoted == '\u0000' ? val.toString().trim() : val.toString());
        }
        return results;
    }

    private static enum State {
        None,
        Key,
        ValueStart,
        Value;

    }
}

