/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.Optional;
import org.n3r.eql.map.FromDbMapper;
import org.n3r.eql.map.MapperFactoryCache;
import org.n3r.eql.map.ResultSetRs;
import org.n3r.eql.map.RsAware;
import org.n3r.eql.util.S;

public class Rs {
    public static String lookupColumnName(ResultSetMetaData resultSetMetaData, int columnIndex) {
        String name = resultSetMetaData.getColumnLabel(columnIndex);
        if (name == null || name.length() < 1) {
            name = resultSetMetaData.getColumnName(columnIndex);
        }
        return name;
    }

    public static Object getResultSetValue(RsAware rs, int index) {
        Object obj = rs.getObject(index);
        if (obj == null) {
            return null;
        }
        String className = obj.getClass().getName();
        if (obj instanceof Blob) {
            obj = rs.getBytes(index);
        } else if (obj instanceof Clob) {
            obj = rs.getString(index);
        } else if (className != null && ("oracle.sql.TIMESTAMP".equals(className) || "oracle.sql.TIMESTAMPTZ".equals(className))) {
            obj = rs.getTimestamp(index);
        } else if (className != null && className.startsWith("oracle.sql.DATE")) {
            String metaDataClassName = rs.getMetaData().getColumnClassName(index);
            obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(index) : rs.getDate(index);
        } else if (obj instanceof Date) {
            if ("java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(index))) {
                obj = rs.getTimestamp(index);
            }
        } else if (obj instanceof String) {
            obj = ((String)obj).trim();
        }
        return obj;
    }

    public static Object getResultSetValue(RsAware rs, int index, Class<?> requiredType) {
        Object value;
        if (requiredType == null) {
            return Rs.getResultSetValue(rs, index);
        }
        boolean wasNullCheck = false;
        if (String.class.equals(requiredType)) {
            int columnType;
            ResultSetMetaData metaData = rs.getMetaData();
            int n = columnType = metaData != null ? metaData.getColumnType(index) : 12;
            value = columnType == 2004 ? S.bytesToStr(rs.getBytes(index)) : S.trim(rs.getString(index));
        } else if (Boolean.TYPE.equals(requiredType) || Boolean.class.equals(requiredType)) {
            value = rs.getBoolean(index);
            wasNullCheck = true;
        } else if (Byte.TYPE.equals(requiredType) || Byte.class.equals(requiredType)) {
            value = rs.getByte(index);
            wasNullCheck = true;
        } else if (Short.TYPE.equals(requiredType) || Short.class.equals(requiredType)) {
            value = rs.getShort(index);
            wasNullCheck = true;
        } else if (Integer.TYPE.equals(requiredType) || Integer.class.equals(requiredType)) {
            value = rs.getInt(index);
            wasNullCheck = true;
        } else if (Long.TYPE.equals(requiredType) || Long.class.equals(requiredType)) {
            value = rs.getLong(index);
            wasNullCheck = true;
        } else if (Float.TYPE.equals(requiredType) || Float.class.equals(requiredType)) {
            value = Float.valueOf(rs.getFloat(index));
            wasNullCheck = true;
        } else if (Double.TYPE.equals(requiredType) || Double.class.equals(requiredType) || Number.class.equals(requiredType)) {
            value = rs.getDouble(index);
            wasNullCheck = true;
        } else if (byte[].class.equals(requiredType)) {
            value = rs.getBytes(index);
        } else if (java.util.Date.class.equals(requiredType)) {
            value = rs.getTimestamp(index);
            if (value != null && !rs.wasNull()) {
                value = new java.util.Date(((Timestamp)value).getTime());
            }
        } else if (Date.class.equals(requiredType)) {
            value = rs.getTimestamp(index);
            if (value != null && !rs.wasNull()) {
                value = new Date(((Timestamp)value).getTime());
            }
        } else {
            Optional<FromDbMapper> mapper = MapperFactoryCache.getFromDbMapper(requiredType);
            value = mapper.isPresent() ? mapper.get().map(rs, index) : Rs.getResultSetValue(rs, index);
        }
        if (wasNullCheck && value != null && rs.wasNull()) {
            value = null;
        }
        return value;
    }

    public static Object getResultSetValue(ResultSet rs, int index) {
        return Rs.getResultSetValue(new ResultSetRs(rs), index);
    }
}

