/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcendents.mybatis.generator.plugin.client;

import java.util.List;
import java.util.regex.Pattern;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.util.StringUtility;

public class AlterResultMapPlugin
extends PluginAdapter {
    public static final String TABLE_NAME = "fullyQualifiedTableName";
    public static final String RESULT_MAP_ID = "resultMapId";
    private String tableName;
    private String resultMapId;
    static final String RESULT_MAP_ATTRIBUTE = "resultMap";
    static final Pattern ANNOTATION_PATTERN = Pattern.compile("@ResultMap\\(\".*\"\\)");
    static final String ANNOTATION_FORMAT = "@ResultMap(\"%s\")";

    public boolean validate(List<String> warnings) {
        this.tableName = this.properties.getProperty(TABLE_NAME);
        this.resultMapId = this.properties.getProperty(RESULT_MAP_ID);
        String warning = "Property %s not set for plugin %s";
        if (!StringUtility.stringHasValue((String)this.tableName)) {
            warnings.add(String.format(warning, TABLE_NAME, ((Object)((Object)this)).getClass().getSimpleName()));
        }
        if (!StringUtility.stringHasValue((String)this.resultMapId)) {
            warnings.add(String.format(warning, RESULT_MAP_ID, ((Object)((Object)this)).getClass().getSimpleName()));
        }
        return StringUtility.stringHasValue((String)this.tableName) && StringUtility.stringHasValue((String)this.resultMapId);
    }

    private boolean tableMatches(IntrospectedTable introspectedTable) {
        return this.tableName.equals(introspectedTable.getFullyQualifiedTableNameAtRuntime());
    }

    void renameResultMapAttribute(XmlElement element, IntrospectedTable introspectedTable) {
        if (this.tableMatches(introspectedTable)) {
            List attributes = element.getAttributes();
            for (int i = 0; i < attributes.size(); ++i) {
                Attribute attribute = (Attribute)attributes.get(i);
                if (!RESULT_MAP_ATTRIBUTE.equals(attribute.getName())) continue;
                Attribute newAtt = new Attribute(RESULT_MAP_ATTRIBUTE, this.resultMapId);
                attributes.remove(i);
                attributes.add(newAtt);
                break;
            }
        }
    }

    void renameResultMapAttribute(Method method, IntrospectedTable introspectedTable) {
        if (this.tableMatches(introspectedTable)) {
            List annotations = method.getAnnotations();
            for (int i = 0; i < annotations.size(); ++i) {
                String annotation = (String)annotations.get(i);
                if (!ANNOTATION_PATTERN.matcher(annotation).matches()) continue;
                String newAnnotation = String.format(ANNOTATION_FORMAT, this.resultMapId);
                annotations.remove(i);
                annotations.add(newAnnotation);
                break;
            }
        }
    }

    public boolean sqlMapSelectByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.renameResultMapAttribute(element, introspectedTable);
        return true;
    }

    public boolean sqlMapSelectByExampleWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.renameResultMapAttribute(element, introspectedTable);
        return true;
    }

    public boolean sqlMapSelectByPrimaryKeyElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.renameResultMapAttribute(element, introspectedTable);
        return true;
    }

    public boolean sqlMapSelectAllElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.renameResultMapAttribute(element, introspectedTable);
        return true;
    }

    public boolean clientSelectByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.renameResultMapAttribute(method, introspectedTable);
        return true;
    }

    public boolean clientSelectByExampleWithBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.renameResultMapAttribute(method, introspectedTable);
        return true;
    }

    public boolean clientSelectByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.renameResultMapAttribute(method, introspectedTable);
        return true;
    }

    public boolean clientSelectByExampleWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.renameResultMapAttribute(method, introspectedTable);
        return true;
    }

    public boolean clientSelectByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.renameResultMapAttribute(method, introspectedTable);
        return true;
    }

    public boolean clientSelectByPrimaryKeyMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.renameResultMapAttribute(method, introspectedTable);
        return true;
    }

    public boolean clientSelectAllMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.renameResultMapAttribute(method, introspectedTable);
        return true;
    }

    public boolean clientSelectAllMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.renameResultMapAttribute(method, introspectedTable);
        return true;
    }
}

