/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcendents.mybatis.generator.plugin.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.JavaFormatter;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.DefaultJavaFormatter;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

public class CreateGenericInterfacePlugin
extends PluginAdapter {
    public static final String INTERFACE = "interface";
    private String interfaceName;
    private Interface genericInterface;
    private FullyQualifiedJavaType genericModel = new FullyQualifiedJavaType("T");
    private FullyQualifiedJavaType genericExample = new FullyQualifiedJavaType("U");
    private FullyQualifiedJavaType genericId = new FullyQualifiedJavaType("V");
    private FullyQualifiedJavaType genericModelList;
    private FullyQualifiedJavaType longPrimitive;
    private Set<String> methodsAdded;
    private Map<IntrospectedTable, FullyQualifiedJavaType> models;
    private Map<IntrospectedTable, FullyQualifiedJavaType> examples;
    private Map<IntrospectedTable, FullyQualifiedJavaType> ids;

    public boolean validate(List<String> warnings) {
        this.interfaceName = this.properties.getProperty(INTERFACE);
        String warning = "Property %s not set for plugin %s";
        if (!StringUtility.stringHasValue((String)this.interfaceName)) {
            warnings.add(String.format(warning, INTERFACE, ((Object)((Object)this)).getClass().getSimpleName()));
            return false;
        }
        this.init();
        return true;
    }

    private void init() {
        this.genericModelList = FullyQualifiedJavaType.getNewListInstance();
        this.genericModelList.addTypeArgument(this.genericModel);
        this.longPrimitive = new FullyQualifiedJavaType("long");
        FullyQualifiedJavaType className = new FullyQualifiedJavaType(this.interfaceName);
        className.addTypeArgument(this.genericModel);
        className.addTypeArgument(this.genericExample);
        className.addTypeArgument(this.genericId);
        this.genericInterface = new Interface(className);
        this.genericInterface.setVisibility(JavaVisibility.PUBLIC);
        this.methodsAdded = new HashSet<String>();
        this.models = new HashMap<IntrospectedTable, FullyQualifiedJavaType>();
        this.examples = new HashMap<IntrospectedTable, FullyQualifiedJavaType>();
        this.ids = new HashMap<IntrospectedTable, FullyQualifiedJavaType>();
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles() {
        ArrayList<GeneratedJavaFile> models = new ArrayList<GeneratedJavaFile>();
        GeneratedJavaFile genericInterfaceFile = new GeneratedJavaFile((CompilationUnit)this.genericInterface, this.context.getJavaClientGeneratorConfiguration().getTargetProject(), (JavaFormatter)new DefaultJavaFormatter());
        models.add(genericInterfaceFile);
        return models;
    }

    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        FullyQualifiedJavaType type = new FullyQualifiedJavaType(this.interfaceName);
        type.addTypeArgument(this.models.get(introspectedTable));
        type.addTypeArgument(this.examples.get(introspectedTable));
        type.addTypeArgument(this.ids.get(introspectedTable));
        interfaze.addSuperInterface(type);
        return true;
    }

    void addGenericMethod(Method method, FullyQualifiedJavaType returnType, FullyQualifiedJavaType ... types) {
        method.addAnnotation("@Override");
        if (!this.methodsAdded.contains(method.getName())) {
            Method genericMethod = new Method(method.getName());
            genericMethod.addJavaDocLine("/**");
            genericMethod.addJavaDocLine(" * This method was generated by MyBatis Generator.");
            genericMethod.addJavaDocLine(" *");
            genericMethod.addJavaDocLine(" * @mbg.generated");
            genericMethod.addJavaDocLine(" */");
            genericMethod.setReturnType(returnType);
            for (int i = 0; i < method.getParameters().size(); ++i) {
                Parameter parameter = (Parameter)method.getParameters().get(i);
                FullyQualifiedJavaType paramType = types.length > i ? types[i] : parameter.getType();
                Parameter genericParameter = new Parameter(paramType, parameter.getName());
                genericMethod.addParameter(genericParameter);
            }
            this.genericInterface.addMethod(genericMethod);
            this.methodsAdded.add(method.getName());
        }
    }

    public boolean clientCountByExampleMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.addClientCountByExample(method, introspectedTable);
        return true;
    }

    public boolean clientCountByExampleMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addClientCountByExample(method, introspectedTable);
        return true;
    }

    private void addClientCountByExample(Method method, IntrospectedTable introspectedTable) {
        this.examples.put(introspectedTable, ((Parameter)method.getParameters().get(0)).getType());
        this.addGenericMethod(method, this.longPrimitive, this.genericExample);
    }

    public boolean clientDeleteByExampleMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.addClientDeleteByExample(method);
        return true;
    }

    public boolean clientDeleteByExampleMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addClientDeleteByExample(method);
        return true;
    }

    private void addClientDeleteByExample(Method method) {
        this.addGenericMethod(method, FullyQualifiedJavaType.getIntInstance(), this.genericExample);
    }

    public boolean clientDeleteByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.addClientDeleteByPrimaryKey(method, introspectedTable);
        return true;
    }

    public boolean clientDeleteByPrimaryKeyMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addClientDeleteByPrimaryKey(method, introspectedTable);
        return true;
    }

    private void addClientDeleteByPrimaryKey(Method method, IntrospectedTable introspectedTable) {
        this.ids.put(introspectedTable, ((Parameter)method.getParameters().get(0)).getType());
        this.addGenericMethod(method, FullyQualifiedJavaType.getIntInstance(), this.genericId);
    }

    public boolean clientInsertMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.addClientInsert(method, introspectedTable);
        return true;
    }

    public boolean clientInsertMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addClientInsert(method, introspectedTable);
        return true;
    }

    private void addClientInsert(Method method, IntrospectedTable introspectedTable) {
        this.models.put(introspectedTable, ((Parameter)method.getParameters().get(0)).getType());
        this.addGenericMethod(method, FullyQualifiedJavaType.getIntInstance(), this.genericModel);
    }

    public boolean clientSelectByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.addClientSelectByExampleWithBLOBs(method);
        return true;
    }

    public boolean clientSelectByExampleWithBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addClientSelectByExampleWithBLOBs(method);
        return true;
    }

    private void addClientSelectByExampleWithBLOBs(Method method) {
        this.addGenericMethod(method, this.genericModelList, this.genericExample);
    }

    public boolean clientSelectByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.addClientSelectByExampleWithoutBLOBs(method);
        return true;
    }

    public boolean clientSelectByExampleWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addClientSelectByExampleWithoutBLOBs(method);
        return true;
    }

    private void addClientSelectByExampleWithoutBLOBs(Method method) {
        this.addGenericMethod(method, this.genericModelList, this.genericExample);
    }

    public boolean clientSelectByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.addClientSelectByPrimaryKey(method);
        return true;
    }

    public boolean clientSelectByPrimaryKeyMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addClientSelectByPrimaryKey(method);
        return true;
    }

    private void addClientSelectByPrimaryKey(Method method) {
        this.addGenericMethod(method, this.genericModel, this.genericId);
    }

    public boolean clientUpdateByExampleSelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.addClientUpdateByExampleSelective(method);
        return true;
    }

    public boolean clientUpdateByExampleSelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addClientUpdateByExampleSelective(method);
        return true;
    }

    private void addClientUpdateByExampleSelective(Method method) {
        this.addGenericMethod(method, FullyQualifiedJavaType.getIntInstance(), this.genericModel, this.genericExample);
    }

    public boolean clientUpdateByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.addClientUpdateByExampleWithBLOBs(method);
        return true;
    }

    public boolean clientUpdateByExampleWithBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addClientUpdateByExampleWithBLOBs(method);
        return true;
    }

    private void addClientUpdateByExampleWithBLOBs(Method method) {
        this.addGenericMethod(method, FullyQualifiedJavaType.getIntInstance(), this.genericModel, this.genericExample);
    }

    public boolean clientUpdateByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.addClientUpdateByExampleWithoutBLOBs(method);
        return true;
    }

    public boolean clientUpdateByExampleWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addClientUpdateByExampleWithoutBLOBs(method);
        return true;
    }

    private void addClientUpdateByExampleWithoutBLOBs(Method method) {
        this.addGenericMethod(method, FullyQualifiedJavaType.getIntInstance(), this.genericModel, this.genericExample);
    }

    public boolean clientUpdateByPrimaryKeySelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.addClientUpdateByPrimaryKeySelective(method);
        return true;
    }

    public boolean clientUpdateByPrimaryKeySelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addClientUpdateByPrimaryKeySelective(method);
        return true;
    }

    private void addClientUpdateByPrimaryKeySelective(Method method) {
        this.addGenericMethod(method, FullyQualifiedJavaType.getIntInstance(), this.genericModel);
    }

    public boolean clientUpdateByPrimaryKeyWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.addClientUpdateByPrimaryKeyWithBLOBs(method);
        return true;
    }

    public boolean clientUpdateByPrimaryKeyWithBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addClientUpdateByPrimaryKeyWithBLOBs(method);
        return true;
    }

    private void addClientUpdateByPrimaryKeyWithBLOBs(Method method) {
        this.addGenericMethod(method, FullyQualifiedJavaType.getIntInstance(), this.genericModel);
    }

    public boolean clientUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.addClientUpdateByPrimaryKeyWithoutBLOBs(method);
        return true;
    }

    public boolean clientUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addClientUpdateByPrimaryKeyWithoutBLOBs(method);
        return true;
    }

    private void addClientUpdateByPrimaryKeyWithoutBLOBs(Method method) {
        this.addGenericMethod(method, FullyQualifiedJavaType.getIntInstance(), this.genericModel);
    }

    public boolean clientInsertSelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.addClientInsertSelective(method);
        return true;
    }

    public boolean clientInsertSelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addClientInsertSelective(method);
        return true;
    }

    private void addClientInsertSelective(Method method) {
        this.addGenericMethod(method, FullyQualifiedJavaType.getIntInstance(), this.genericModel);
    }

    public boolean clientSelectAllMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.addClientSelectAll(method);
        return true;
    }

    public boolean clientSelectAllMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addClientSelectAll(method);
        return true;
    }

    private void addClientSelectAll(Method method) {
        this.addGenericMethod(method, this.genericModel, new FullyQualifiedJavaType[0]);
    }
}

