/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcendents.mybatis.generator.plugin.dynamic.sql;

import com.github.dcendents.mybatis.generator.plugin.dynamic.sql.DynamicSqlSupportClassGenerator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.JavaFormatter;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.DefaultJavaFormatter;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class DynamicSqlPlugin
extends PluginAdapter {
    public static final String TABLE_CLASS_SUFFIX = "tableClassSuffix";
    public static final String ADD_ALIASED_COLUMNS = "addAliasedColumns";
    public static final String ADD_TABLE_ALIAS = "addTableAlias";
    public static final String TABLE_ALIAS_FIELD_NAME = "tableAliasFieldName";
    public static final String DEFAULT_TABLE_ALIAS_FIELD = "tableAlias";
    private String tableClassSuffix;
    private boolean addAliasedColumns;
    private boolean addTableAlias;
    private String tableAliasFieldName;

    public boolean validate(List<String> warnings) {
        this.tableClassSuffix = this.properties.getProperty(TABLE_CLASS_SUFFIX);
        String addAliasedColumnsString = this.properties.getProperty(ADD_ALIASED_COLUMNS);
        String addTableAliasString = this.properties.getProperty(ADD_TABLE_ALIAS);
        this.tableAliasFieldName = this.properties.getProperty(TABLE_ALIAS_FIELD_NAME);
        this.tableClassSuffix = this.tableClassSuffix == null ? "" : this.tableClassSuffix.trim();
        this.addAliasedColumns = Boolean.parseBoolean(addAliasedColumnsString);
        this.addTableAlias = Boolean.parseBoolean(addTableAliasString);
        if (StringUtils.isBlank((CharSequence)this.tableAliasFieldName)) {
            this.tableAliasFieldName = DEFAULT_TABLE_ALIAS_FIELD;
        }
        return true;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        ArrayList<GeneratedJavaFile> models = new ArrayList<GeneratedJavaFile>();
        TopLevelClass unit = DynamicSqlSupportClassGenerator.of(introspectedTable, this.context.getCommentGenerator(), this.tableClassSuffix, this.addAliasedColumns, this.addTableAlias, this.tableAliasFieldName, this.properties).generate();
        GeneratedJavaFile dynamicSqlModel = new GeneratedJavaFile((CompilationUnit)unit, this.context.getJavaClientGeneratorConfiguration().getTargetProject(), (JavaFormatter)new DefaultJavaFormatter());
        models.add(dynamicSqlModel);
        return models;
    }
}

