/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcendents.mybatis.generator.plugin.dynamic.sql;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;

public class DynamicSqlSupportClassGenerator {
    private IntrospectedTable introspectedTable;
    private CommentGenerator commentGenerator;
    private String sqlTableClassName;
    private boolean addAliasedColumns;
    private boolean addTableAlias;
    private String tableAliasFieldName;
    private Properties properties;

    private DynamicSqlSupportClassGenerator() {
    }

    public TopLevelClass generate() {
        TopLevelClass topLevelClass = this.buildBasicClass();
        Field tableField = this.calculateTableDefinition(topLevelClass);
        topLevelClass.addImportedType(tableField.getType());
        topLevelClass.addField(tableField);
        InnerClass innerClass = this.buildInnerTableClass(topLevelClass);
        topLevelClass.addInnerClass(innerClass);
        this.handleAliases(topLevelClass, innerClass, tableField.getName());
        List columns = this.introspectedTable.getAllColumns();
        for (IntrospectedColumn column : columns) {
            this.handleColumn(topLevelClass, innerClass, column, tableField.getName());
        }
        return topLevelClass;
    }

    private String calculateClassName() {
        FullyQualifiedJavaType mapperType = new FullyQualifiedJavaType(this.introspectedTable.getMyBatis3JavaMapperType());
        FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(this.introspectedTable.getBaseRecordType());
        return mapperType.getPackageName() + "." + recordType.getShortNameWithoutTypeArguments() + "DynamicSqlSupport";
    }

    private TopLevelClass buildBasicClass() {
        TopLevelClass topLevelClass = new TopLevelClass(this.calculateClassName());
        topLevelClass.setVisibility(JavaVisibility.PUBLIC);
        topLevelClass.setFinal(true);
        topLevelClass.addImportedType(new FullyQualifiedJavaType("org.mybatis.dynamic.sql.SqlColumn"));
        topLevelClass.addImportedType(new FullyQualifiedJavaType("org.mybatis.dynamic.sql.SqlTable"));
        topLevelClass.addImportedType(new FullyQualifiedJavaType("java.sql.JDBCType"));
        return topLevelClass;
    }

    private InnerClass buildInnerTableClass(TopLevelClass topLevelClass) {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(this.sqlTableClassName);
        InnerClass innerClass = new InnerClass(fqjt.getShortName());
        innerClass.setVisibility(JavaVisibility.PUBLIC);
        innerClass.setStatic(true);
        innerClass.setFinal(true);
        innerClass.setSuperClass(new FullyQualifiedJavaType("org.mybatis.dynamic.sql.SqlTable"));
        Method method = new Method(fqjt.getShortName());
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setConstructor(true);
        method.addBodyLine("super(\"" + StringUtility.escapeStringForJava((String)this.introspectedTable.getFullyQualifiedTableNameAtRuntime()) + "\");");
        innerClass.addMethod(method);
        this.commentGenerator.addClassAnnotation(innerClass, this.introspectedTable, topLevelClass.getImportedTypes());
        return innerClass;
    }

    private Field calculateTableDefinition(TopLevelClass topLevelClass) {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(this.sqlTableClassName);
        String fieldName = JavaBeansUtil.getValidPropertyName((String)this.sqlTableClassName);
        Field field = new Field(fieldName, fqjt);
        this.commentGenerator.addFieldAnnotation(field, this.introspectedTable, topLevelClass.getImportedTypes());
        field.setVisibility(JavaVisibility.PUBLIC);
        field.setStatic(true);
        field.setFinal(true);
        StringBuilder initializationString = new StringBuilder();
        initializationString.append(String.format("new %s()", StringUtility.escapeStringForJava((String)this.sqlTableClassName)));
        field.setInitializationString(initializationString.toString());
        return field;
    }

    private void handleAliases(TopLevelClass topLevelClass, InnerClass innerClass, String tableFieldName) {
        String alias = this.introspectedTable.getFullyQualifiedTable().getAlias();
        if (this.addTableAlias && StringUtils.isNotBlank((CharSequence)alias) && StringUtils.isNotBlank((CharSequence)this.tableAliasFieldName)) {
            this.handleAlias(topLevelClass, innerClass, tableFieldName, this.tableAliasFieldName, alias);
        }
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(this.introspectedTable.getFullyQualifiedTableNameAtRuntime() + ".")) continue;
            String aliasField = key.substring(this.introspectedTable.getFullyQualifiedTableNameAtRuntime().length() + 1);
            this.handleAlias(topLevelClass, innerClass, tableFieldName, aliasField, value);
        }
    }

    private void handleAlias(TopLevelClass topLevelClass, InnerClass innerClass, String tableFieldName, String aliasFieldName, String alias) {
        FullyQualifiedJavaType fieldType = FullyQualifiedJavaType.getStringInstance();
        Field field = new Field(aliasFieldName, fieldType);
        field.setVisibility(JavaVisibility.PUBLIC);
        field.setStatic(true);
        field.setFinal(true);
        field.setInitializationString(tableFieldName + "." + aliasFieldName);
        this.commentGenerator.addFieldAnnotation(field, this.introspectedTable, topLevelClass.getImportedTypes());
        topLevelClass.addField(field);
        field = new Field(aliasFieldName, fieldType);
        field.setVisibility(JavaVisibility.PUBLIC);
        field.setFinal(true);
        field.setInitializationString(String.format("\"%s\"", alias));
        innerClass.addField(field);
    }

    private void handleColumn(TopLevelClass topLevelClass, InnerClass innerClass, IntrospectedColumn column, String tableFieldName) {
        topLevelClass.addImportedType(column.getFullyQualifiedJavaType());
        FullyQualifiedJavaType fieldType = this.calculateFieldType(column);
        String fieldName = column.getJavaProperty();
        Field field = new Field(fieldName, fieldType);
        field.setVisibility(JavaVisibility.PUBLIC);
        field.setStatic(true);
        field.setFinal(true);
        field.setInitializationString(tableFieldName + "." + fieldName);
        this.commentGenerator.addFieldAnnotation(field, this.introspectedTable, column, topLevelClass.getImportedTypes());
        topLevelClass.addField(field);
        if (this.addAliasedColumns && StringUtils.isNotBlank((CharSequence)column.getTableAlias())) {
            field = new Field(column.getTableAlias() + StringUtils.capitalize((String)fieldName), fieldType);
            field.setVisibility(JavaVisibility.PUBLIC);
            field.setStatic(true);
            field.setFinal(true);
            field.setInitializationString(tableFieldName + "." + fieldName);
            this.commentGenerator.addFieldAnnotation(field, this.introspectedTable, column, topLevelClass.getImportedTypes());
            topLevelClass.addField(field);
        }
        field = new Field(fieldName, fieldType);
        field.setVisibility(JavaVisibility.PUBLIC);
        field.setFinal(true);
        field.setInitializationString(this.calculateInnerInitializationString(column));
        innerClass.addField(field);
    }

    private FullyQualifiedJavaType calculateFieldType(IntrospectedColumn column) {
        Object typeParameter = column.getFullyQualifiedJavaType().isPrimitive() ? column.getFullyQualifiedJavaType().getPrimitiveTypeWrapper() : column.getFullyQualifiedJavaType();
        return new FullyQualifiedJavaType(String.format("SqlColumn<%s>", typeParameter.getShortName()));
    }

    private String calculateInnerInitializationString(IntrospectedColumn column) {
        StringBuilder initializationString = new StringBuilder();
        initializationString.append(String.format("column(\"%s\", JDBCType.%s", StringUtility.escapeStringForJava((String)MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)column)), column.getJdbcTypeName()));
        if (StringUtility.stringHasValue((String)column.getTypeHandler())) {
            initializationString.append(String.format(", \"%s\")", column.getTypeHandler()));
        } else {
            initializationString.append(')');
        }
        return initializationString.toString();
    }

    public static DynamicSqlSupportClassGenerator of(IntrospectedTable introspectedTable, CommentGenerator commentGenerator, String sqlTableClassSuffix, boolean addAliasedColumns, boolean addTableAlias, String tableAliasFieldName, Properties properties) {
        DynamicSqlSupportClassGenerator generator = new DynamicSqlSupportClassGenerator();
        generator.introspectedTable = introspectedTable;
        generator.commentGenerator = commentGenerator;
        generator.sqlTableClassName = introspectedTable.getFullyQualifiedTable().getDomainObjectName() + sqlTableClassSuffix;
        generator.addAliasedColumns = addAliasedColumns;
        generator.addTableAlias = addTableAlias;
        generator.tableAliasFieldName = tableAliasFieldName;
        generator.properties = properties;
        return generator;
    }
}

