/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcendents.mybatis.generator.plugin.locking;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

public class OptimisticLockingPlugin
extends PluginAdapter {
    public static final String TABLE_NAME = "fullyQualifiedTableName";
    public static final String LOCK_COLUMN = "lockColumn";
    public static final String LOCK_COLUMN_FUNCTION = "lockColumnFunction";
    private String tableName;
    private String lockColumn;
    private String lockColumnFunction;
    static final String METHOD_SUFFIX = "WithOptimisticLocking";

    public boolean validate(List<String> warnings) {
        this.tableName = this.properties.getProperty(TABLE_NAME);
        this.lockColumn = this.properties.getProperty(LOCK_COLUMN);
        this.lockColumnFunction = this.properties.getProperty(LOCK_COLUMN_FUNCTION);
        String warning = "Property %s not set for plugin %s";
        if (!StringUtility.stringHasValue((String)this.tableName)) {
            warnings.add(String.format(warning, TABLE_NAME, ((Object)((Object)this)).getClass().getSimpleName()));
        }
        if (!StringUtility.stringHasValue((String)this.lockColumn)) {
            warnings.add(String.format(warning, LOCK_COLUMN, ((Object)((Object)this)).getClass().getSimpleName()));
        }
        if (StringUtils.isBlank((CharSequence)this.lockColumnFunction)) {
            this.lockColumnFunction = this.lockColumn;
        }
        return StringUtility.stringHasValue((String)this.tableName) && StringUtility.stringHasValue((String)this.lockColumn);
    }

    boolean tableMatches(IntrospectedTable introspectedTable) {
        return this.tableName.equals(introspectedTable.getFullyQualifiedTableNameAtRuntime()) || Pattern.matches(this.tableName, introspectedTable.getFullyQualifiedTableNameAtRuntime());
    }

    public boolean clientUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (this.tableMatches(introspectedTable)) {
            Method withLock = this.addMethod(method, introspectedTable);
            interfaze.addMethod(withLock);
        }
        return true;
    }

    public boolean clientUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (this.tableMatches(introspectedTable)) {
            Method withLock = this.addMethod(method, introspectedTable);
            topLevelClass.addMethod(withLock);
        }
        return true;
    }

    Method addMethod(Method method, IntrospectedTable introspectedTable) {
        IntrospectedColumn column = this.getColumn(introspectedTable);
        Method withLock = new Method(method);
        withLock.setName(method.getName() + METHOD_SUFFIX);
        withLock.getAnnotations().clear();
        for (String line : method.getAnnotations()) {
            if (line.matches("\\s*\".*\"\\s*")) {
                withLock.getAnnotations().add(line + ",");
                String typeHandler = column.getTypeHandler() != null ? String.format(",typeHandler=%s", column.getTypeHandler()) : "";
                withLock.getAnnotations().add(String.format("    \"and %1$s = #{%2$s,jdbcType=%3$s%4$s}\"", this.lockColumnFunction, column.getJavaProperty(), column.getJdbcTypeName(), typeHandler));
                continue;
            }
            withLock.getAnnotations().add(line);
        }
        return withLock;
    }

    IntrospectedColumn getColumn(IntrospectedTable introspectedTable) {
        for (IntrospectedColumn column : introspectedTable.getAllColumns()) {
            if (!this.lockColumn.equals(column.getActualColumnName())) continue;
            return column;
        }
        return null;
    }
}

