/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcendents.mybatis.generator.plugin.model;

import java.util.List;
import java.util.regex.Pattern;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

public class AlterModelPlugin
extends PluginAdapter {
    public static final String TABLE_NAME = "fullyQualifiedTableName";
    public static final String ADD_INTERFACES = "addInterfaces";
    private String tableName;
    private String[] addInterfaces;

    public boolean validate(List<String> warnings) {
        this.tableName = this.properties.getProperty(TABLE_NAME);
        String interfacesString = this.properties.getProperty(ADD_INTERFACES);
        String warning = "Property %s not set for plugin %s";
        if (!StringUtility.stringHasValue((String)this.tableName)) {
            warnings.add(String.format(warning, TABLE_NAME, ((Object)((Object)this)).getClass().getSimpleName()));
        }
        if (!StringUtility.stringHasValue((String)interfacesString)) {
            warnings.add(String.format(warning, ADD_INTERFACES, ((Object)((Object)this)).getClass().getSimpleName()));
        } else {
            this.addInterfaces = interfacesString.split(",");
        }
        return StringUtility.stringHasValue((String)this.tableName) && this.addInterfaces != null;
    }

    private boolean tableMatches(IntrospectedTable introspectedTable) {
        return this.tableName.equals(introspectedTable.getFullyQualifiedTableNameAtRuntime()) || Pattern.matches(this.tableName, introspectedTable.getFullyQualifiedTableNameAtRuntime());
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (this.tableMatches(introspectedTable)) {
            for (String theInterface : this.addInterfaces) {
                FullyQualifiedJavaType type = new FullyQualifiedJavaType(theInterface);
                topLevelClass.addImportedType(type);
                topLevelClass.addSuperInterface(type);
            }
        }
        return true;
    }
}

