/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcendents.mybatis.generator.plugin.rename;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameExampleClassAndMethodsPlugin
extends PluginAdapter {
    private static final Logger log = LoggerFactory.getLogger(RenameExampleClassAndMethodsPlugin.class);
    public static final String VALIDATION_ERROR_MESSAGE = "ValidationError.18";
    public static final String CLASS_SEARCH_PROPERTY = "classMethodSearchString";
    public static final String CLASS_REPLACE_PROPERTY = "classMethodReplaceString";
    public static final String PARAM_SEARCH_PROPERTY = "parameterSearchString";
    public static final String PARAM_REPLACE_PROPERTY = "parameterReplaceString";
    static final String XML_ID_ATTRIBUTE = "id";
    private String classMethodReplaceString;
    private Pattern classMethodPattern;
    private String parameterReplaceString;
    private Pattern parameterPattern;

    public boolean validate(List<String> warnings) {
        boolean valid;
        String classMethodSearchString = this.properties.getProperty(CLASS_SEARCH_PROPERTY);
        this.classMethodReplaceString = this.properties.getProperty(CLASS_REPLACE_PROPERTY);
        String parameterSearchString = this.properties.getProperty(PARAM_SEARCH_PROPERTY);
        this.parameterReplaceString = this.properties.getProperty(PARAM_REPLACE_PROPERTY);
        boolean bl = valid = StringUtility.stringHasValue((String)classMethodSearchString) && StringUtility.stringHasValue((String)this.classMethodReplaceString) && StringUtility.stringHasValue((String)parameterSearchString) && StringUtility.stringHasValue((String)this.parameterReplaceString);
        if (valid) {
            this.classMethodPattern = Pattern.compile(classMethodSearchString);
            this.parameterPattern = Pattern.compile(parameterSearchString);
        } else {
            if (!StringUtility.stringHasValue((String)classMethodSearchString)) {
                warnings.add(Messages.getString((String)VALIDATION_ERROR_MESSAGE, (String)RenameExampleClassAndMethodsPlugin.class.getSimpleName(), (String)CLASS_SEARCH_PROPERTY));
            }
            if (!StringUtility.stringHasValue((String)this.classMethodReplaceString)) {
                warnings.add(Messages.getString((String)VALIDATION_ERROR_MESSAGE, (String)RenameExampleClassAndMethodsPlugin.class.getSimpleName(), (String)CLASS_REPLACE_PROPERTY));
            }
            if (!StringUtility.stringHasValue((String)parameterSearchString)) {
                warnings.add(Messages.getString((String)VALIDATION_ERROR_MESSAGE, (String)RenameExampleClassAndMethodsPlugin.class.getSimpleName(), (String)PARAM_SEARCH_PROPERTY));
            }
            if (!StringUtility.stringHasValue((String)this.parameterReplaceString)) {
                warnings.add(Messages.getString((String)VALIDATION_ERROR_MESSAGE, (String)RenameExampleClassAndMethodsPlugin.class.getSimpleName(), (String)PARAM_REPLACE_PROPERTY));
            }
        }
        return valid;
    }

    public void initialized(IntrospectedTable introspectedTable) {
        String oldType = introspectedTable.getExampleType();
        Matcher matcher = this.classMethodPattern.matcher(oldType);
        oldType = matcher.replaceAll(this.classMethodReplaceString);
        introspectedTable.setExampleType(oldType);
    }

    boolean renameMethod(Method method) {
        String oldMethodName = method.getName();
        Matcher matcher = this.classMethodPattern.matcher(oldMethodName);
        String newMethodName = matcher.replaceAll(this.classMethodReplaceString);
        method.setName(newMethodName);
        for (int i = 0; i < method.getParameters().size(); ++i) {
            Parameter parameter = (Parameter)method.getParameters().get(i);
            String oldParamName = parameter.getName();
            matcher = this.parameterPattern.matcher(oldParamName);
            if (!matcher.lookingAt()) continue;
            String newName = matcher.replaceAll(this.parameterReplaceString);
            Parameter newParam = new Parameter(parameter.getType(), newName, parameter.isVarargs());
            for (String annotation : parameter.getAnnotations()) {
                newParam.addAnnotation(annotation);
            }
            method.getParameters().set(i, newParam);
        }
        return true;
    }

    boolean renameElement(XmlElement element) {
        for (int i = 0; i < element.getAttributes().size(); ++i) {
            Attribute attribute = (Attribute)element.getAttributes().get(i);
            if (!XML_ID_ATTRIBUTE.equals(attribute.getName())) continue;
            String oldValue = attribute.getValue();
            Matcher matcher = this.classMethodPattern.matcher(oldValue);
            String newValue = matcher.replaceAll(this.classMethodReplaceString);
            Attribute newAtt = new Attribute(attribute.getName(), newValue);
            element.getAttributes().set(i, newAtt);
        }
        return true;
    }

    void removeIdColumns(IntrospectedTable introspectedTable, XmlElement element) {
        ArrayList<String> updates = new ArrayList<String>();
        String alias = introspectedTable.getTableConfiguration().getAlias();
        alias = alias == null ? "" : alias + ".";
        List ids = introspectedTable.getPrimaryKeyColumns();
        for (IntrospectedColumn column : ids) {
            String typeHandler = column.getTypeHandler() != null ? String.format(",typeHandler=%s", column.getTypeHandler()) : "";
            String update = String.format("%4$s%1$s = #{record.%2$s,jdbcType=%3$s%5$s},", column.getActualColumnName(), column.getJavaProperty(), column.getJdbcTypeName(), alias, typeHandler);
            log.debug("update: {}", (Object)update);
            updates.add(update);
        }
        if (!updates.isEmpty()) {
            this.removeIdColumns(updates, (Element)element, null, -1);
        }
    }

    void removeIdColumns(List<String> updates, Element element, XmlElement parent, int index) {
        block3: {
            block2: {
                log.debug("element type: {}", (Object)element.getClass().getSimpleName());
                log.debug("element: {}", (Object)element.getFormattedContent(0));
                if (!(element instanceof TextElement)) break block2;
                TextElement textElement = (TextElement)element;
                for (String update : updates) {
                    if (!textElement.getContent().contains(update)) continue;
                    TextElement newElement = new TextElement(textElement.getContent().replace(update, ""));
                    parent.getElements().set(index, newElement);
                }
                break block3;
            }
            if (!(element instanceof XmlElement)) break block3;
            XmlElement xmlElement = (XmlElement)element;
            for (int i = 0; i < xmlElement.getElements().size(); ++i) {
                Element e = (Element)xmlElement.getElements().get(i);
                this.removeIdColumns(updates, e, xmlElement, i);
            }
        }
    }

    public boolean clientCountByExampleMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientCountByExampleMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientDeleteByExampleMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientDeleteByExampleMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientDeleteByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientDeleteByPrimaryKeyMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientSelectByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientSelectByExampleWithBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientSelectByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientSelectByExampleWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByExampleSelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByExampleSelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByExampleWithBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByExampleWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean sqlMapCountByExampleElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return this.renameElement(element);
    }

    public boolean sqlMapDeleteByExampleElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return this.renameElement(element);
    }

    public boolean sqlMapSelectByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return this.renameElement(element);
    }

    public boolean sqlMapSelectByExampleWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return this.renameElement(element);
    }

    public boolean sqlMapUpdateByExampleSelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.removeIdColumns(introspectedTable, element);
        return this.renameElement(element);
    }

    public boolean sqlMapUpdateByExampleWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.removeIdColumns(introspectedTable, element);
        return this.renameElement(element);
    }

    public boolean sqlMapUpdateByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.removeIdColumns(introspectedTable, element);
        return this.renameElement(element);
    }
}

