/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.ChangeFreq;
import com.redfin.sitemapgenerator.W3CDateFormat;
import com.redfin.sitemapgenerator.WebSitemapUrl;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractSitemapUrlOptions<U extends WebSitemapUrl, THIS extends AbstractSitemapUrlOptions<U, THIS>> {
    Date lastMod;
    ChangeFreq changeFreq;
    Double priority;
    URL url;
    Class<U> clazz;

    public AbstractSitemapUrlOptions(String url, Class<U> clazz) throws MalformedURLException {
        this(new URL(url), clazz);
    }

    public AbstractSitemapUrlOptions(URL url, Class<U> clazz) {
        if (url == null) {
            throw new NullPointerException("URL may not be null");
        }
        this.url = url;
        this.clazz = clazz;
    }

    public THIS lastMod(Date lastMod) {
        this.lastMod = lastMod;
        return this.getThis();
    }

    public THIS lastMod(String lastMod) throws ParseException {
        this.lastMod = new W3CDateFormat().parse(lastMod);
        return this.getThis();
    }

    public THIS changeFreq(ChangeFreq changeFreq) {
        this.changeFreq = changeFreq;
        return this.getThis();
    }

    public THIS priority(Double priority) {
        if (priority > 1.0) {
            throw new IllegalArgumentException("Priority may not be greater than 1.0: " + priority);
        }
        if (priority < 0.0) {
            throw new IllegalArgumentException("Priority may not be less than 0: " + priority);
        }
        this.priority = priority;
        return this.getThis();
    }

    THIS getThis() {
        return (THIS)this;
    }

    public U build() {
        try {
            return (U)((WebSitemapUrl)this.clazz.getConstructor(this.getClass()).newInstance(this));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

