/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.AbstractSitemapGeneratorOptions;
import com.redfin.sitemapgenerator.ISitemapUrl;
import com.redfin.sitemapgenerator.ISitemapUrlRenderer;
import com.redfin.sitemapgenerator.SitemapIndexGenerator;
import com.redfin.sitemapgenerator.SitemapValidator;
import com.redfin.sitemapgenerator.UrlUtils;
import com.redfin.sitemapgenerator.W3CDateFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SitemapGenerator<U extends ISitemapUrl, THIS extends SitemapGenerator<U, THIS>> {
    public static final int MAX_URLS_PER_SITEMAP = 50000;
    private final URL baseUrl;
    private final File baseDir;
    private final String fileNamePrefix;
    private final String fileNameSuffix;
    private final boolean allowEmptySitemap;
    private final boolean allowMultipleSitemaps;
    private final ArrayList<U> urls = new ArrayList();
    private final W3CDateFormat dateFormat;
    private final int maxUrls;
    private final boolean autoValidate;
    private final boolean gzip;
    private final ISitemapUrlRenderer<U> renderer;
    private int mapCount = 0;
    private boolean finished = false;
    private final ArrayList<File> outFiles = new ArrayList();

    public SitemapGenerator(AbstractSitemapGeneratorOptions<?> options, ISitemapUrlRenderer<U> renderer) {
        this.baseDir = options.baseDir;
        this.baseUrl = options.baseUrl;
        this.fileNamePrefix = options.fileNamePrefix;
        W3CDateFormat dateFormat = options.dateFormat;
        if (dateFormat == null) {
            dateFormat = new W3CDateFormat();
        }
        this.dateFormat = dateFormat;
        this.allowEmptySitemap = options.allowEmptySitemap;
        this.allowMultipleSitemaps = options.allowMultipleSitemaps;
        this.maxUrls = options.maxUrls;
        this.autoValidate = options.autoValidate;
        this.gzip = options.gzip;
        this.renderer = renderer;
        this.fileNameSuffix = options.suffixStringPattern != null && !options.suffixStringPattern.isEmpty() ? (this.gzip ? options.suffixStringPattern + ".xml.gz" : options.suffixStringPattern + ".xml") : (this.gzip ? ".xml.gz" : ".xml");
    }

    public THIS addUrl(U url) {
        if (this.finished) {
            throw new RuntimeException("Sitemap already printed; you must create a new generator to make more sitemaps");
        }
        UrlUtils.checkUrl(url.getUrl(), this.baseUrl);
        if (this.urls.size() == this.maxUrls) {
            if (!this.allowMultipleSitemaps) {
                throw new RuntimeException("More than " + this.maxUrls + " urls, but allowMultipleSitemaps is false.  Enable allowMultipleSitemaps to split the sitemap into multiple files with a sitemap index.");
            }
            if (this.baseDir != null) {
                if (this.mapCount == 0) {
                    ++this.mapCount;
                }
                try {
                    this.writeSiteMap();
                }
                catch (IOException ex) {
                    throw new RuntimeException("Closing of stream failed.", ex);
                }
                ++this.mapCount;
                this.urls.clear();
            }
        }
        this.urls.add(url);
        return this.getThis();
    }

    public THIS addUrls(Iterable<? extends U> urls) {
        for (ISitemapUrl url : urls) {
            this.addUrl(url);
        }
        return this.getThis();
    }

    public THIS addUrls(U ... urls) {
        for (U url : urls) {
            this.addUrl(url);
        }
        return this.getThis();
    }

    public THIS addUrls(String ... urls) {
        for (String url : urls) {
            this.addUrl(url);
        }
        return this.getThis();
    }

    public THIS addUrl(String url) {
        try {
            ISitemapUrl sitemapUrl = (ISitemapUrl)this.renderer.getUrlClass().getConstructor(String.class).newInstance(url);
            return this.addUrl(sitemapUrl);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public THIS addUrls(URL ... urls) {
        for (URL url : urls) {
            this.addUrl(url);
        }
        return this.getThis();
    }

    public THIS addUrl(URL url) {
        try {
            ISitemapUrl sitemapUrl = (ISitemapUrl)this.renderer.getUrlClass().getConstructor(URL.class).newInstance(url);
            return this.addUrl(sitemapUrl);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    THIS getThis() {
        return (THIS)this;
    }

    public List<File> write() {
        if (this.finished) {
            throw new RuntimeException("Sitemap already printed; you must create a new generator to make more sitemaps");
        }
        if (!this.allowEmptySitemap && this.urls.isEmpty() && this.mapCount == 0) {
            throw new RuntimeException("No URLs added, sitemap would be empty; you must add some URLs with addUrls");
        }
        try {
            this.writeSiteMap();
        }
        catch (IOException ex) {
            throw new RuntimeException("Closing of streams has failed at some point.", ex);
        }
        this.finished = true;
        return this.outFiles;
    }

    public List<String> writeAsStrings() {
        ArrayList<String> listOfSiteMapStrings = new ArrayList<String>();
        for (int start = 0; start < this.urls.size(); start += this.maxUrls) {
            int end = start + this.maxUrls;
            if (end > this.urls.size()) {
                end = this.urls.size();
            }
            StringBuilder sb = new StringBuilder();
            this.writeSiteMapAsString(sb, this.urls.subList(start, end));
            listOfSiteMapStrings.add(sb.toString());
        }
        return listOfSiteMapStrings;
    }

    private void writeSiteMapAsString(StringBuilder sb, List<U> urls) {
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\" ");
        if (this.renderer.getXmlNamespaces() != null) {
            sb.append(this.renderer.getXmlNamespaces());
            sb.append(' ');
        }
        sb.append(">\n");
        for (ISitemapUrl url : urls) {
            this.renderer.render(url, sb, this.dateFormat);
        }
        sb.append("</urlset>");
    }

    public File writeSitemapsWithIndex() {
        return this.writeSitemapsWithIndex(new File(this.baseDir, "sitemap_index.xml"));
    }

    public String writeSitemapsWithIndexAsString() {
        return this.prepareSitemapIndexGenerator(null).writeAsString();
    }

    public File writeSitemapsWithIndex(File outFile) {
        this.prepareSitemapIndexGenerator(outFile).write();
        return outFile;
    }

    private SitemapIndexGenerator prepareSitemapIndexGenerator(File outFile) {
        if (!this.finished) {
            throw new RuntimeException("Sitemaps not generated yet; call write() first");
        }
        SitemapIndexGenerator sig = new SitemapIndexGenerator.Options(this.baseUrl, outFile).dateFormat(this.dateFormat).autoValidate(this.autoValidate).build();
        sig.addUrls(this.fileNamePrefix, this.fileNameSuffix, this.mapCount);
        return sig;
    }

    private void writeSiteMap() throws IOException {
        if (this.baseDir == null) {
            throw new NullPointerException("To write to files, baseDir must not be null");
        }
        if (this.urls.isEmpty() && (this.mapCount > 0 || !this.allowEmptySitemap)) {
            return;
        }
        String fileNamePrefix = this.mapCount > 0 ? this.fileNamePrefix + this.mapCount : this.fileNamePrefix;
        File outFile = new File(this.baseDir, fileNamePrefix + this.fileNameSuffix);
        this.outFiles.add(outFile);
        OutputStreamWriter out = null;
        try {
            if (this.gzip) {
                FileOutputStream fileStream = new FileOutputStream(outFile);
                GZIPOutputStream gzipStream = new GZIPOutputStream(fileStream);
                out = new OutputStreamWriter((OutputStream)gzipStream, Charset.forName("UTF-8").newEncoder());
            } else {
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), Charset.forName("UTF-8").newEncoder());
            }
            this.writeSiteMap(out);
            out.flush();
            if (this.autoValidate) {
                SitemapValidator.validateWebSitemap(outFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Problem writing sitemap file " + outFile, e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Sitemap file failed to validate (bug?)", e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void writeSiteMap(OutputStreamWriter out) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.writeSiteMapAsString(sb, this.urls);
        out.write(sb.toString());
    }
}

