/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.druid.autoconfigure;

import com.alibaba.druid.pool.DruidDataSource;
import com.github.trang.druid.autoconfigure.DruidDataSourceCustomizer;
import com.github.trang.druid.autoconfigure.datasource.DruidDataSource2;
import com.github.trang.druid.autoconfigure.util.CharMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

@Import(value={DruidDataSourceImportSelector.class})
public class DruidDataSourceConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DruidDataSourceConfiguration.class);
    private static final String BEAN_NAME = "dataSource";
    private static final String BEAN_SUFFIX = "DataSource";
    private static final String PREFIX = "spring.datasource.druid.data-sources";

    private static BeanDefinition genericDruidBeanDefinition() {
        return BeanDefinitionBuilder.genericBeanDefinition(DruidDataSource2.class).setInitMethodName("init").setDestroyMethodName("close").getBeanDefinition();
    }

    static class DruidDataSourceImportSelector
    implements ImportSelector,
    EnvironmentAware {
        private Map<String, Object> dataSources;

        DruidDataSourceImportSelector() {
        }

        public void setEnvironment(Environment environment) {
            this.dataSources = (Map)Binder.get((Environment)environment).bind(DruidDataSourceConfiguration.PREFIX, Bindable.mapOf(String.class, Object.class)).orElse(Collections.emptyMap());
        }

        public String[] selectImports(AnnotationMetadata metadata) {
            Stream.Builder<Class<DruidDataSourceBeanPostProcessor>> imposts = Stream.builder().add(DruidDataSourceBeanPostProcessor.class);
            imposts.add(this.dataSources.isEmpty() ? SingleDataSourceRegistrar.class : DynamicDataSourceRegistrar.class);
            return (String[])imposts.build().map(Class::getName).toArray(String[]::new);
        }
    }

    static class DruidDataSourceBeanPostProcessor
    implements EnvironmentAware,
    BeanPostProcessor {
        private final List<DruidDataSourceCustomizer> customizers;
        private Environment environment;
        private Map<String, Object> dataSources;

        public DruidDataSourceBeanPostProcessor(ObjectProvider<List<DruidDataSourceCustomizer>> customizers) {
            this.customizers = (List)customizers.getIfAvailable(ArrayList::new);
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
            this.dataSources = (Map)Binder.get((Environment)environment).bind(DruidDataSourceConfiguration.PREFIX, Bindable.mapOf(String.class, Object.class)).orElse(Collections.emptyMap());
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof DruidDataSource) {
                if (this.dataSources.isEmpty()) {
                    log.info("druid single data-source({}) init...", (Object)beanName);
                } else {
                    log.info("druid dynamic data-source({}) init...", (Object)beanName);
                }
                DruidDataSource druidDataSource = (DruidDataSource)bean;
                druidDataSource.setName(beanName);
                if (!this.dataSources.isEmpty()) {
                    Binder.get((Environment)this.environment).bind("spring.datasource.druid.data-sources." + beanName, Bindable.ofInstance((Object)druidDataSource));
                }
                this.customizers.forEach(customizer -> customizer.customize(druidDataSource));
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }

    static class DynamicDataSourceRegistrar
    implements ImportBeanDefinitionRegistrar,
    EnvironmentAware {
        private Map<String, Object> dataSources;

        DynamicDataSourceRegistrar() {
        }

        public void setEnvironment(Environment environment) {
            this.dataSources = (Map)Binder.get((Environment)environment).bind(DruidDataSourceConfiguration.PREFIX, Bindable.mapOf(String.class, Object.class)).orElse(Collections.emptyMap());
        }

        public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
            this.dataSources.keySet().forEach(dataSourceName -> {
                String camelName = CharMatcher.separatedToCamel().apply((String)dataSourceName);
                registry.registerBeanDefinition(camelName, DruidDataSourceConfiguration.genericDruidBeanDefinition());
                if (!StringUtils.endsWithIgnoreCase((String)camelName, (String)DruidDataSourceConfiguration.BEAN_SUFFIX)) {
                    registry.registerAlias(camelName, camelName + DruidDataSourceConfiguration.BEAN_SUFFIX);
                }
            });
        }
    }

    static class SingleDataSourceRegistrar
    implements ImportBeanDefinitionRegistrar {
        SingleDataSourceRegistrar() {
        }

        public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
            if (!registry.containsBeanDefinition(DruidDataSourceConfiguration.BEAN_NAME)) {
                registry.registerBeanDefinition(DruidDataSourceConfiguration.BEAN_NAME, DruidDataSourceConfiguration.genericDruidBeanDefinition());
            }
        }
    }
}

