/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.druid.autoconfigure.datasource.init;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.jdbc.DataSourceInitializationMode;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.config.SortedResourcesFactoryBean;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.util.StringUtils;

public class DataSourceInitializer {
    private static final Log logger = LogFactory.getLog(DataSourceInitializer.class);
    private final List<DruidDataSource> dataSources;
    private final DataSourceProperties properties;
    private final ResourceLoader resourceLoader;

    public DataSourceInitializer(List<DruidDataSource> dataSources, DataSourceProperties properties, ResourceLoader resourceLoader) {
        this.dataSources = dataSources;
        this.properties = properties;
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    public DataSourceInitializer(List<DruidDataSource> dataSources, DataSourceProperties properties) {
        this(dataSources, properties, null);
    }

    public List<DruidDataSource> getDataSources() {
        return this.dataSources;
    }

    public boolean createSchema() {
        List<Resource> scripts = this.getScripts("spring.datasource.schema", this.properties.getSchema(), "schema");
        if (!scripts.isEmpty()) {
            if (!this.isEnabled()) {
                logger.debug((Object)"Initialization disabled (not running DDL scripts)");
                return false;
            }
            String username = this.properties.getSchemaUsername();
            String password = this.properties.getSchemaPassword();
            this.runScripts(scripts, username, password);
        }
        return !scripts.isEmpty();
    }

    public void initSchema() {
        List<Resource> scripts = this.getScripts("spring.datasource.data", this.properties.getData(), "data");
        if (!scripts.isEmpty()) {
            if (!this.isEnabled()) {
                logger.debug((Object)"Initialization disabled (not running data scripts)");
                return;
            }
            String username = this.properties.getDataUsername();
            String password = this.properties.getDataPassword();
            this.runScripts(scripts, username, password);
        }
    }

    private boolean isEnabled() {
        DataSourceInitializationMode mode = this.properties.getInitializationMode();
        if (mode == DataSourceInitializationMode.NEVER) {
            return false;
        }
        return mode != DataSourceInitializationMode.EMBEDDED || this.isEmbedded();
    }

    private boolean isEmbedded() {
        try {
            return this.dataSources.stream().allMatch(EmbeddedDatabaseConnection::isEmbedded);
        }
        catch (Exception ex) {
            logger.debug((Object)"Could not determine if datasource is embedded", (Throwable)ex);
            return false;
        }
    }

    private List<Resource> getScripts(String propertyName, List<String> resources, String fallback) {
        if (resources != null) {
            return this.getResources(propertyName, resources, true);
        }
        String platform = this.properties.getPlatform();
        ArrayList<String> fallbackResources = new ArrayList<String>();
        fallbackResources.add("classpath*:" + fallback + "-" + platform + ".sql");
        fallbackResources.add("classpath*:" + fallback + ".sql");
        return this.getResources(propertyName, fallbackResources, false);
    }

    private List<Resource> getResources(String propertyName, List<String> locations, boolean validate) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String location : locations) {
            for (Resource resource : this.doGetResources(location)) {
                if (resource.exists()) {
                    resources.add(resource);
                    continue;
                }
                if (!validate) continue;
                throw new InvalidConfigurationPropertyValueException(propertyName, (Object)resource, "The specified resource does not exist.");
            }
        }
        return resources;
    }

    private Resource[] doGetResources(String location) {
        try {
            SortedResourcesFactoryBean factory = new SortedResourcesFactoryBean(this.resourceLoader, Collections.singletonList(location));
            factory.afterPropertiesSet();
            return (Resource[])factory.getObject();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to load resources from " + location, ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void runScripts(List<Resource> resources, String username, String password) {
        boolean isDifferent;
        if (resources.isEmpty()) {
            return;
        }
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.setContinueOnError(this.properties.isContinueOnError());
        populator.setSeparator(this.properties.getSeparator());
        if (this.properties.getSqlScriptEncoding() != null) {
            populator.setSqlScriptEncoding(this.properties.getSqlScriptEncoding().name());
        }
        for (Resource resource : resources) {
            populator.addScript(resource);
        }
        List<DruidDataSource> dataSources = this.dataSources;
        boolean bl = isDifferent = username != null && !this.properties.getUsername().equals(username) || password != null && !this.properties.getPassword().equals(password);
        if (username == null) {
            username = this.properties.getUsername();
        }
        if (password == null) {
            password = this.properties.getPassword();
        }
        if (StringUtils.hasText((String)username) && StringUtils.hasText((String)password)) {
            for (DataSource dataSource : dataSources) {
                void var8_9;
                if (isDifferent) {
                    DataSource dataSource2 = DataSourceBuilder.create((ClassLoader)this.properties.getClassLoader()).driverClassName(this.properties.determineDriverClassName()).url(this.properties.determineUrl()).username(username).password(password).build();
                }
                DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)var8_9);
            }
        }
    }
}

