/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonzou.jmockdata.mocker;

import com.github.jsonzou.jmockdata.DataConfig;
import com.github.jsonzou.jmockdata.Mocker;
import com.github.jsonzou.jmockdata.mocker.ArrayMocker;
import com.github.jsonzou.jmockdata.mocker.BeanMocker;
import com.github.jsonzou.jmockdata.mocker.CollectionMocker;
import com.github.jsonzou.jmockdata.mocker.EnumMocker;
import com.github.jsonzou.jmockdata.mocker.MapMocker;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

public class ClassMocker
implements Mocker<Object> {
    private Class clazz;
    private Type[] genericTypes;

    ClassMocker(Class clazz, Type[] genericTypes) {
        this.clazz = clazz;
        this.genericTypes = genericTypes;
    }

    @Override
    public Object mock(DataConfig mockConfig) {
        Mocker<Object> mocker;
        if (this.clazz.isArray()) {
            mocker = new ArrayMocker(this.clazz);
        } else if (Map.class.isAssignableFrom(this.clazz)) {
            mocker = new MapMocker(this.genericTypes);
        } else if (Collection.class.isAssignableFrom(this.clazz)) {
            mocker = new CollectionMocker(this.clazz, this.genericTypes[0]);
        } else if (this.clazz.isEnum()) {
            mocker = new EnumMocker(this.clazz);
        } else {
            mocker = mockConfig.globalConfig().getMocker(this.clazz);
            if (mocker == null) {
                mocker = new BeanMocker(this.clazz);
            }
        }
        return mocker.mock(mockConfig);
    }
}

