/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.plus.core;

import com.github.lianjiatech.retrofit.plus.core.RequestHolder;
import com.github.lianjiatech.retrofit.plus.core.ResponseHolder;
import com.github.lianjiatech.retrofit.plus.exception.FailResponseException;
import com.github.lianjiatech.retrofit.plus.exception.HttpExecuteException;
import com.github.lianjiatech.retrofit.plus.exception.HttpIOException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Retrofit;

public final class BodyCallAdapterFactory
extends CallAdapter.Factory {
    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (Call.class.isAssignableFrom(BodyCallAdapterFactory.getRawType((Type)returnType))) {
            return null;
        }
        if (CompletableFuture.class.isAssignableFrom(BodyCallAdapterFactory.getRawType((Type)returnType))) {
            return null;
        }
        if (retrofit2.Response.class.isAssignableFrom(BodyCallAdapterFactory.getRawType((Type)returnType))) {
            return null;
        }
        return new BodyCallAdapter(returnType);
    }

    final class BodyCallAdapter<R>
    implements CallAdapter<R, R> {
        private Type returnType;

        public BodyCallAdapter(Type returnType) {
            this.returnType = returnType;
        }

        public Type responseType() {
            return this.returnType;
        }

        public R adapt(Call<R> call) {
            retrofit2.Response response;
            Request request = call.request();
            try {
                response = call.execute();
            }
            catch (IOException e) {
                RequestHolder requestHolder = new RequestHolder(request);
                throw new HttpIOException(requestHolder, null, e);
            }
            catch (Exception e) {
                RequestHolder requestHolder = new RequestHolder(request);
                throw new HttpExecuteException(requestHolder, null, e);
            }
            if (!response.isSuccessful()) {
                RequestHolder requestHolder = new RequestHolder(request);
                Response raw = response.raw();
                ResponseBody errorBody = response.errorBody();
                ResponseHolder responseHolder = new ResponseHolder(raw, errorBody);
                throw new FailResponseException(requestHolder, responseHolder);
            }
            return (R)response.body();
        }
    }
}

