/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.plus.core;

import com.github.lianjiatech.retrofit.plus.annotation.RetrofitClient;
import com.github.lianjiatech.retrofit.plus.config.Config;
import com.github.lianjiatech.retrofit.plus.core.RetrofitFactoryBean;
import com.github.lianjiatech.retrofit.plus.core.RetrofitHelper;
import com.github.lianjiatech.retrofit.plus.util.BeanExtendUtils;
import com.github.lianjiatech.retrofit.plus.util.SpringBootBindUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ClassPathRetrofitClientScanner
extends ClassPathBeanDefinitionScanner {
    private static final Logger log = LoggerFactory.getLogger(ClassPathRetrofitClientScanner.class);
    private final ClassLoader classLoader;
    private String retrofitHelperRefBeanName;
    private RetrofitHelper retrofitHelper;
    private RetrofitFactoryBean<?> retrofitFactoryBean = new RetrofitFactoryBean();

    public ClassPathRetrofitClientScanner(BeanDefinitionRegistry registry, ClassLoader classLoader) {
        super(registry, false);
        this.classLoader = classLoader;
    }

    public void registerFilters() {
        AnnotationTypeFilter annotationTypeFilter = new AnnotationTypeFilter(RetrofitClient.class);
        this.addIncludeFilter((TypeFilter)annotationTypeFilter);
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            this.logger.warn((Object)("No RetrofitClient was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration."));
        } else {
            this.processBeanDefinitions(beanDefinitions);
        }
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        if (beanDefinition.getMetadata().isInterface()) {
            try {
                Class target = ClassUtils.forName((String)beanDefinition.getMetadata().getClassName(), (ClassLoader)this.classLoader);
                return !target.isAnnotation();
            }
            catch (Exception ex) {
                log.error("load class exception:", (Throwable)ex);
            }
        }
        return false;
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating RetrofitClientBean with name '" + holder.getBeanName() + "' and '" + definition.getBeanClassName() + "' Interface"));
            }
            definition.getConstructorArgumentValues().addGenericArgumentValue((Object)Objects.requireNonNull(definition.getBeanClassName()));
            definition.setBeanClass(this.retrofitFactoryBean.getClass());
            if (StringUtils.hasText((String)this.retrofitHelperRefBeanName)) {
                definition.getPropertyValues().add("retrofitHelper", (Object)new RuntimeBeanReference(this.retrofitHelperRefBeanName));
                continue;
            }
            definition.getPropertyValues().add("retrofitHelper", (Object)this.retrofitHelper);
        }
    }

    public void setRetrofitHelperRefBeanName(String retrofitHelperRefBeanName) {
        this.retrofitHelperRefBeanName = retrofitHelperRefBeanName;
    }

    public void setRetrofitEnvironment(Environment environment) {
        Config config = SpringBootBindUtil.bind(environment, Config.class, "retrofit-plus");
        Config defaultConfig = new Config();
        Config mergeConfig = this.mergeConfig(config, defaultConfig);
        if (this.retrofitHelper == null) {
            this.retrofitHelper = new RetrofitHelper();
        }
        this.retrofitHelper.setConfig(mergeConfig);
    }

    @NonNull
    private Config mergeConfig(Config config, Config defaultConfig) {
        if (config == null) {
            return defaultConfig;
        }
        if (defaultConfig == null) {
            return config;
        }
        return BeanExtendUtils.combineProperties(config, defaultConfig);
    }
}

