/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.plus.core;

import com.github.lianjiatech.retrofit.plus.util.HttpDataUtils;
import java.nio.charset.Charset;
import java.util.Objects;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.springframework.util.StringUtils;

public class RequestHolder {
    private final Request request;

    public RequestHolder(Request request) {
        this.request = request;
    }

    public String basicString() {
        if (this.request == null) {
            return null;
        }
        return this.request.toString();
    }

    public String headersString() {
        if (this.request == null) {
            return null;
        }
        Headers headers = this.request.headers();
        return "requestHeader" + HttpDataUtils.headersString(headers);
    }

    public String bodyString() {
        if (this.request == null) {
            return null;
        }
        RequestBody requestBody = this.request.body();
        if (requestBody == null || HttpDataUtils.bodyHasUnknownEncoding(this.request.headers())) {
            return null;
        }
        StringBuilder result = new StringBuilder("requestBody");
        Buffer buffer = new Buffer();
        requestBody.writeTo((BufferedSink)buffer);
        Charset charset = Charset.forName("UTF-8");
        MediaType contentType = requestBody.contentType();
        if (contentType != null) {
            charset = contentType.charset(charset);
        }
        if (HttpDataUtils.isPlaintext(buffer)) {
            result.append(buffer.readString(Objects.requireNonNull(charset))).append("(").append(requestBody.contentLength()).append("-byte body)");
        } else {
            result.append("(binary ").append(requestBody.contentLength()).append("-byte body omitted)");
        }
        return result.toString();
    }

    public String toString() {
        String requestBodyString;
        String requestHeaderString;
        StringBuilder buffer = new StringBuilder();
        String basicRequestString = this.basicString();
        if (StringUtils.hasText((String)basicRequestString)) {
            buffer.append(basicRequestString).append(", ");
        }
        if (StringUtils.hasText((String)(requestHeaderString = this.headersString()))) {
            buffer.append(requestHeaderString).append(", ");
        }
        if (StringUtils.hasText((String)(requestBodyString = this.bodyString()))) {
            buffer.append(requestBodyString).append(", ");
        }
        return buffer.toString();
    }
}

