/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.plus.core;

import com.github.lianjiatech.retrofit.plus.util.HttpDataUtils;
import java.nio.charset.Charset;
import java.util.Objects;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Source;
import org.springframework.util.StringUtils;

public class ResponseHolder {
    public static final String GZIP = "gzip";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    private final Response response;
    private final ResponseBody responseBody;

    public ResponseHolder(Response response, ResponseBody responseBody) {
        this.response = response;
        this.responseBody = responseBody;
    }

    public String basicString(Long tookMs) {
        if (this.response == null) {
            return null;
        }
        StringBuilder result = new StringBuilder("response{protocol=").append(this.response.protocol()).append(", code=").append(this.response.code()).append(", message=").append(this.response.message().isEmpty() ? " " : ' ' + this.response.message());
        if (tookMs != null) {
            result.append(", time=").append(tookMs).append("ms");
        }
        result.append("}");
        return result.toString();
    }

    public String headersString() {
        if (this.response == null) {
            return null;
        }
        Headers headers = this.response.headers();
        return "responseHeader" + HttpDataUtils.headersString(headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String bodyString() {
        if (this.response == null) {
            return null;
        }
        if (HttpDataUtils.bodyHasUnknownEncoding(this.response.headers())) {
            return null;
        }
        StringBuilder result = new StringBuilder("responseBody");
        Headers headers = this.response.headers();
        BufferedSource source = this.responseBody.source();
        long contentLength = this.responseBody.contentLength();
        source.request(Long.MAX_VALUE);
        Buffer buffer = source.buffer();
        Long gzippedLength = null;
        if (GZIP.equalsIgnoreCase(headers.get(CONTENT_ENCODING))) {
            gzippedLength = buffer.size();
            try (GzipSource gzippedResponseBody = null;){
                gzippedResponseBody = new GzipSource((Source)buffer.clone());
                buffer = new Buffer();
                buffer.writeAll((Source)gzippedResponseBody);
            }
        }
        Charset charset = Charset.forName("UTF-8");
        MediaType contentType = this.responseBody.contentType();
        if (contentType != null) {
            charset = contentType.charset(charset);
        }
        if (!HttpDataUtils.isPlaintext(buffer)) {
            result.append("(binary ").append(buffer.size()).append("-byte body omitted)");
        } else if (contentLength != 0L) {
            result.append(buffer.clone().readString(Objects.requireNonNull(charset)));
        }
        if (gzippedLength != null) {
            result.append("(").append(buffer.size()).append("-byte, ").append(gzippedLength).append("-gzipped-byte body)");
        } else {
            result.append("(").append(buffer.size()).append("-byte body)");
        }
        return result.toString();
    }

    public String toString() {
        String responseBodyString;
        String responseHeaderString;
        StringBuilder buffer = new StringBuilder();
        String basicResponseString = this.basicString(null);
        if (StringUtils.hasText((String)basicResponseString)) {
            buffer.append(basicResponseString).append(", ");
        }
        if (StringUtils.hasText((String)(responseHeaderString = this.headersString()))) {
            buffer.append(responseHeaderString).append(", ");
        }
        if (StringUtils.hasText((String)(responseBodyString = this.bodyString()))) {
            buffer.append(responseBodyString).append(", ");
        }
        return buffer.toString();
    }
}

