/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.plus.core;

import com.github.lianjiatech.retrofit.plus.annotation.RetrofitScan;
import com.github.lianjiatech.retrofit.plus.core.ClassPathRetrofitClientScanner;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RetrofitClientRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
BeanClassLoaderAware,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(RetrofitClientRegistrar.class);
    private ResourceLoader resourceLoader;
    private ClassLoader classLoader;
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(RetrofitScan.class.getName()));
        ClassPathRetrofitClientScanner scanner = new ClassPathRetrofitClientScanner(registry, this.classLoader);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        String[] basePackages = this.getPackagesToScan(attributes);
        String retrofitHelperRef = attributes.getString("retrofitHelperRef");
        if (StringUtils.hasText((String)retrofitHelperRef)) {
            scanner.setRetrofitHelperRefBeanName(retrofitHelperRef);
        } else {
            try {
                scanner.setRetrofitEnvironment(this.environment);
            }
            catch (Exception e) {
                log.warn("\u53ea\u6709 Spring Boot \u73af\u5883\u4e2d\u53ef\u4ee5\u901a\u8fc7 Environment(\u914d\u7f6e\u6587\u4ef6,\u73af\u5883\u53d8\u91cf,\u8fd0\u884c\u53c2\u6570\u7b49\u65b9\u5f0f) \u914d\u7f6e\u901a\u7528 retrofit\uff0c\u5176\u4ed6\u73af\u5883\u8bf7\u901a\u8fc7 @RetrofitScan \u6ce8\u89e3\u4e2d\u7684 retrofitHelperRef\u8fdb\u884c\u914d\u7f6e!", (Throwable)e);
            }
        }
        scanner.registerFilters();
        scanner.doScan(basePackages);
    }

    private String[] getPackagesToScan(AnnotationAttributes attributes) {
        Object[] value = attributes.getStringArray("value");
        Object[] basePackages = attributes.getStringArray("basePackages");
        Class[] basePackageClasses = attributes.getClassArray("basePackageClasses");
        if (!ObjectUtils.isEmpty((Object[])value)) {
            Assert.state((boolean)ObjectUtils.isEmpty((Object[])basePackages), (String)"@RetrofitScan basePackages and value attributes are mutually exclusive");
        }
        LinkedHashSet<Object> packagesToScan = new LinkedHashSet<Object>();
        packagesToScan.addAll(Arrays.asList(value));
        packagesToScan.addAll(Arrays.asList(basePackages));
        for (Class basePackageClass : basePackageClasses) {
            packagesToScan.add(ClassUtils.getPackageName((Class)basePackageClass));
        }
        return packagesToScan.toArray(new String[packagesToScan.size()]);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

