/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.plus.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.lianjiatech.retrofit.plus.annotation.InterceptMark;
import com.github.lianjiatech.retrofit.plus.annotation.RetrofitClient;
import com.github.lianjiatech.retrofit.plus.config.Config;
import com.github.lianjiatech.retrofit.plus.config.PoolConfig;
import com.github.lianjiatech.retrofit.plus.core.BodyCallAdapterFactory;
import com.github.lianjiatech.retrofit.plus.core.ResponseCallAdapterFactory;
import com.github.lianjiatech.retrofit.plus.core.RetrofitHelper;
import com.github.lianjiatech.retrofit.plus.interceptor.BaseGlobalInterceptor;
import com.github.lianjiatech.retrofit.plus.interceptor.BasePathMatchInterceptor;
import com.github.lianjiatech.retrofit.plus.interceptor.LogInterceptor;
import com.github.lianjiatech.retrofit.plus.util.BeanExtendUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class RetrofitFactoryBean<T>
implements FactoryBean<T>,
EnvironmentAware,
InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(RetrofitFactoryBean.class);
    private Class<T> retrofitInterface;
    private ConfigurableEnvironment environment;
    private Map<String, ConnectionPool> poolRegistry = new ConcurrentHashMap<String, ConnectionPool>(4);
    private RetrofitHelper retrofitHelper;
    private ApplicationContext applicationContext;
    private BodyCallAdapterFactory bodyCallAdapterFactory;
    private ResponseCallAdapterFactory responseCallAdapterFactory;
    private JacksonConverterFactory jacksonConverterFactory = JacksonConverterFactory.create((ObjectMapper)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL));
    private static final String DEFAULT_KEY = "default";

    public RetrofitFactoryBean() {
    }

    public RetrofitFactoryBean(Class<T> retrofitInterface) {
        this.retrofitInterface = retrofitInterface;
    }

    public T getObject() {
        if (log.isDebugEnabled()) {
            log.debug("\u5f53\u524dretrofit\u63a5\u53e3\u4e3a={}, global_config = {}", this.retrofitInterface, (Object)this.retrofitHelper.getConfig());
        }
        this.checkRetrofitInterface(this.retrofitInterface);
        Retrofit retrofit = this.getRetrofit(this.retrofitInterface);
        return (T)retrofit.create(this.retrofitInterface);
    }

    private void checkRetrofitInterface(Class<T> retrofitInterface) {
        Assert.isTrue((boolean)retrofitInterface.isInterface(), (String)"@RetrofitClient\u53ea\u80fd\u4f5c\u7528\u5728\u63a5\u53e3\u7c7b\u578b\u4e0a\uff01");
        Method[] methods = retrofitInterface.getMethods();
        Config config = this.retrofitHelper.getConfig();
        for (Method method : methods) {
            Class<?> returnType = method.getReturnType();
            Assert.isTrue((!Void.TYPE.isAssignableFrom(returnType) ? 1 : 0) != 0, (String)("\u4e0d\u652f\u6301\u4f7f\u7528void\u5173\u952e\u5b57\u505a\u8fd4\u56de\u7c7b\u578b\uff0c\u8bf7\u4f7f\u7528java.lang.Void! method=" + method));
            if (!config.isDisableVoidReturnType()) continue;
            Assert.isTrue((!Void.class.isAssignableFrom(returnType) ? 1 : 0) != 0, (String)("\u5df2\u914d\u7f6e\u7981\u7528Void\u4f5c\u4e3a\u8fd4\u56de\u503c\uff0c\u8bf7\u6307\u5b9a\u5176\u4ed6\u8fd4\u56de\u7c7b\u578b\uff01method=" + method));
        }
    }

    public Class<T> getObjectType() {
        return this.retrofitInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    private synchronized ConnectionPool getConnectionPool(Class<?> retrofitClientInterfaceClass) {
        RetrofitClient retrofitClient = retrofitClientInterfaceClass.getAnnotation(RetrofitClient.class);
        String poolName = retrofitClient.poolName();
        ConnectionPool connectionPool = this.poolRegistry.get(poolName);
        Assert.notNull((Object)connectionPool, (String)("\u5f53\u524dpoolName\u5bf9\u5e94\u7684\u8fde\u63a5\u6c60\u4e0d\u5b58\u5728\uff01poolName = " + poolName));
        return connectionPool;
    }

    private synchronized OkHttpClient getOkHttpClient(Class<?> retrofitClientInterfaceClass) {
        ConnectionPool connectionPool = this.getConnectionPool(retrofitClientInterfaceClass);
        RetrofitClient retrofitClient = retrofitClientInterfaceClass.getAnnotation(RetrofitClient.class);
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().connectTimeout((long)retrofitClient.connectTimeoutMs(), TimeUnit.MILLISECONDS).readTimeout((long)retrofitClient.readTimeoutMs(), TimeUnit.MILLISECONDS).writeTimeout((long)retrofitClient.writeTimeoutMs(), TimeUnit.MILLISECONDS).connectionPool(connectionPool);
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>(this.findInterceptorByAnnotation(retrofitClientInterfaceClass));
        Collection<BaseGlobalInterceptor> globalInterceptors = this.getBeans(BaseGlobalInterceptor.class);
        if (globalInterceptors != null) {
            interceptors.addAll(globalInterceptors);
        }
        interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).addInterceptor(arg_0));
        Config config = this.retrofitHelper.getConfig();
        if (config.isEnableLog()) {
            LogInterceptor.Logger logger = LogInterceptor.innerLogger(retrofitClient.logLevel(), log);
            okHttpClientBuilder.addInterceptor((Interceptor)new LogInterceptor(logger, retrofitClient.logStrategy()));
        }
        return okHttpClientBuilder.build();
    }

    private List<Interceptor> findInterceptorByAnnotation(Class<?> retrofitClientInterfaceClass) {
        Annotation[] classAnnotations = retrofitClientInterfaceClass.getAnnotations();
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        ArrayList<Annotation> interceptAnnotations = new ArrayList<Annotation>();
        for (Annotation classAnnotation : classAnnotations) {
            Class<? extends Annotation> annotationType = classAnnotation.annotationType();
            if (!annotationType.isAnnotationPresent(InterceptMark.class)) continue;
            interceptAnnotations.add(classAnnotation);
        }
        for (Annotation interceptAnnotation : interceptAnnotations) {
            Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)interceptAnnotation);
            Object handler = annotationAttributes.get("handler");
            Assert.notNull(handler, (String)"@InterceptMark\u6807\u8bb0\u7684\u6ce8\u89e3\u5fc5\u987b\u914d\u7f6e: Class<? extends BasePathMatchInterceptor> handler()");
            Assert.notNull(annotationAttributes.get("include"), (String)"@InterceptMark\u6807\u8bb0\u7684\u6ce8\u89e3\u5fc5\u987b\u914d\u7f6e: String[] include()");
            Assert.notNull(annotationAttributes.get("exclude"), (String)"@InterceptMark\u6807\u8bb0\u7684\u6ce8\u89e3\u5fc5\u987b\u914d\u7f6e: String[] exclude()");
            Class interceptorClass = (Class)handler;
            BasePathMatchInterceptor interceptor = this.getInterceptorInstance(interceptorClass);
            BeanExtendUtils.populate(interceptor, annotationAttributes);
            interceptor.setEnvironment((Environment)this.environment);
            interceptors.add(interceptor);
        }
        return interceptors;
    }

    private BasePathMatchInterceptor getInterceptorInstance(Class<? extends BasePathMatchInterceptor> interceptorClass) {
        if (this.isComponent(interceptorClass)) {
            return (BasePathMatchInterceptor)this.applicationContext.getBean(interceptorClass);
        }
        return interceptorClass.newInstance();
    }

    private boolean isComponent(Class<? extends BasePathMatchInterceptor> interceptorClass) {
        if (interceptorClass.isAnnotationPresent(Component.class)) {
            return true;
        }
        if (interceptorClass.isAnnotationPresent(Service.class)) {
            return true;
        }
        if (interceptorClass.isAnnotationPresent(Controller.class)) {
            return true;
        }
        return interceptorClass.isAnnotationPresent(Repository.class);
    }

    public synchronized Retrofit getRetrofit(Class<?> retrofitClientInterfaceClass) {
        Collection<Converter.Factory> factoryCollection;
        RetrofitClient retrofitClient = retrofitClientInterfaceClass.getAnnotation(RetrofitClient.class);
        String baseUrl = retrofitClient.baseUrl();
        baseUrl = this.formatBaseUrl(baseUrl);
        OkHttpClient client = this.getOkHttpClient(retrofitClientInterfaceClass);
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(baseUrl).client(client);
        Config config = this.retrofitHelper.getConfig();
        ArrayList<CallAdapter.Factory> callAdapterFactories = new ArrayList<CallAdapter.Factory>();
        ArrayList<Object> converterFactories = new ArrayList<Object>();
        Collection<CallAdapter.Factory> factories = this.getBeans(CallAdapter.Factory.class);
        if (!CollectionUtils.isEmpty(factories)) {
            callAdapterFactories.addAll(factories);
        }
        if (CollectionUtils.isEmpty(factoryCollection = this.getBeans(Converter.Factory.class))) {
            converterFactories.add(this.jacksonConverterFactory);
        } else {
            converterFactories.addAll(factoryCollection);
        }
        if (config.isEnableBodyCallAdapter()) {
            this.bodyCallAdapterFactory = Optional.ofNullable(this.bodyCallAdapterFactory).orElse(new BodyCallAdapterFactory());
            callAdapterFactories.add(this.bodyCallAdapterFactory);
        }
        if (config.isEnableResponseCallAdapter()) {
            this.responseCallAdapterFactory = Optional.ofNullable(this.responseCallAdapterFactory).orElse(new ResponseCallAdapterFactory());
            callAdapterFactories.add(this.responseCallAdapterFactory);
        }
        callAdapterFactories.forEach(arg_0 -> ((Retrofit.Builder)retrofitBuilder).addCallAdapterFactory(arg_0));
        converterFactories.forEach(arg_0 -> ((Retrofit.Builder)retrofitBuilder).addConverterFactory(arg_0));
        return retrofitBuilder.build();
    }

    private <U> Collection<U> getBeans(Class<U> clz) {
        try {
            Map beanMap = this.applicationContext.getBeansOfType(clz);
            return beanMap.values();
        }
        catch (BeansException beansException) {
            return null;
        }
    }

    private String formatBaseUrl(String baseUrl) {
        return this.environment.resolveRequiredPlaceholders(baseUrl);
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public void afterPropertiesSet() {
        Map<String, PoolConfig> pool;
        MutablePropertySources propertySources = this.environment.getPropertySources();
        Properties properties = this.retrofitHelper.getProperties();
        if (properties != null) {
            PropertiesPropertySource propertySource = new PropertiesPropertySource("retrofitHelperProperties", properties);
            propertySources.addFirst((PropertySource)propertySource);
        }
        if ((pool = this.retrofitHelper.getConfig().getPool()) != null) {
            pool.forEach((poolName, poolConfig) -> {
                long keepAliveSecond = poolConfig.getKeepAliveSecond();
                int maxIdleConnections = poolConfig.getMaxIdleConnections();
                ConnectionPool connectionPool = new ConnectionPool(maxIdleConnections, keepAliveSecond, TimeUnit.SECONDS);
                this.poolRegistry.put((String)poolName, connectionPool);
            });
        }
        if (!this.poolRegistry.containsKey(DEFAULT_KEY)) {
            this.poolRegistry.put(DEFAULT_KEY, new ConnectionPool());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setRetrofitInterface(Class<T> retrofitInterface) {
        this.retrofitInterface = retrofitInterface;
    }

    public Class<T> getRetrofitInterface() {
        return this.retrofitInterface;
    }

    public void setRetrofitHelper(RetrofitHelper retrofitHelper) {
        this.retrofitHelper = retrofitHelper;
    }

    public RetrofitHelper getRetrofitHelper() {
        return this.retrofitHelper;
    }
}

