/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.plus.interceptor;

import com.github.lianjiatech.retrofit.plus.core.RequestHolder;
import com.github.lianjiatech.retrofit.plus.core.ResponseHolder;
import com.github.lianjiatech.retrofit.plus.interceptor.LogStrategy;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.util.StringUtils;

public final class LogInterceptor
implements Interceptor {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(LogInterceptor.class);
    private final Logger logger;
    private LogStrategy logStrategy;

    public LogInterceptor(Logger logger, LogStrategy logStrategy) {
        this.logger = logger;
        this.logStrategy = logStrategy;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.logStrategy == LogStrategy.NONE) {
            return chain.proceed(request);
        }
        Response response = null;
        long start = System.currentTimeMillis();
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.logger.log("[HTTP FAILED:] " + e);
            throw e;
        }
        finally {
            this.printLog(request, response, start);
        }
        return response;
    }

    private void printLog(Request request, Response response, long start) {
        try {
            RequestHolder requestHolder = new RequestHolder(request);
            ResponseHolder responseHolder = new ResponseHolder(response, response == null ? null : response.body());
            boolean logBody = this.logStrategy == LogStrategy.BODY;
            boolean logHeaders = logBody || this.logStrategy == LogStrategy.HEADERS;
            String basicRequestString = requestHolder.basicString();
            if (StringUtils.hasText((String)basicRequestString)) {
                this.logger.log(basicRequestString);
            }
            this.logHeadersAndBody(logBody, logHeaders, requestHolder.headersString(), requestHolder.bodyString());
            String basicResponseString = responseHolder.basicString(System.currentTimeMillis() - start);
            if (StringUtils.hasText((String)basicResponseString)) {
                this.logger.log(basicResponseString);
            }
            this.logHeadersAndBody(logBody, logHeaders, responseHolder.headersString(), responseHolder.bodyString());
        }
        catch (Exception e) {
            log.warn("Failed to print log!", (Throwable)e);
        }
    }

    private void logHeadersAndBody(boolean logBody, boolean logHeaders, String headerString, String bodyString) {
        if (logHeaders) {
            if (StringUtils.hasText((String)headerString)) {
                this.logger.log(headerString);
            }
            if (logBody && StringUtils.hasText((String)bodyString)) {
                this.logger.log(bodyString);
            }
        }
    }

    public static Logger innerLogger(Level level, org.slf4j.Logger logger) {
        if (level == Level.DEBUG) {
            return arg_0 -> ((org.slf4j.Logger)logger).debug(arg_0);
        }
        if (level == Level.ERROR) {
            return arg_0 -> ((org.slf4j.Logger)logger).error(arg_0);
        }
        if (level == Level.INFO) {
            return arg_0 -> ((org.slf4j.Logger)logger).info(arg_0);
        }
        if (level == Level.TRACE) {
            return arg_0 -> ((org.slf4j.Logger)logger).trace(arg_0);
        }
        if (level == Level.WARN) {
            return arg_0 -> ((org.slf4j.Logger)logger).warn(arg_0);
        }
        throw new UnsupportedOperationException("We don't support this log level currently.");
    }

    public static interface Logger {
        public void log(String var1);
    }
}

