/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.plus.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.springframework.beans.BeanUtils;

public final class BeanExtendUtils {
    public static <T> T combineProperties(T sourceBean, T targetBean) {
        Class<?> sourceBeanClass = sourceBean.getClass();
        Class<?> targetBeanClass = targetBean.getClass();
        Field[] sourceFields = sourceBeanClass.getDeclaredFields();
        Field[] targetFields = targetBeanClass.getDeclaredFields();
        for (int i = 0; i < sourceFields.length; ++i) {
            Field targetField;
            Field sourceField = sourceFields[i];
            if (Modifier.isStatic(sourceField.getModifiers()) || Modifier.isStatic((targetField = targetFields[i]).getModifiers())) continue;
            sourceField.setAccessible(true);
            targetField.setAccessible(true);
            if (sourceField.get(sourceBean) == null || "serialVersionUID".equals(sourceField.getName())) continue;
            targetField.set(targetBean, sourceField.get(sourceBean));
        }
        return targetBean;
    }

    public static void populate(Object bean, Map<String, ?> properties) {
        if (bean == null || properties == null) {
            return;
        }
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            String name = entry.getKey();
            if (name == null) continue;
            BeanExtendUtils.setProperty(bean, name, entry.getValue());
        }
    }

    public static void setProperty(Object bean, String name, Object value) {
        Class<?> beanClass = bean.getClass();
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(beanClass, (String)name);
        if (propertyDescriptor == null) {
            return;
        }
        Method writeMethod = propertyDescriptor.getWriteMethod();
        try {
            writeMethod.invoke(bean, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private BeanExtendUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

