/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.plus.util;

import java.io.EOFException;
import okhttp3.Headers;
import okio.Buffer;

public final class HttpDataUtils {
    private static final int INT_16 = 16;

    public static boolean isPlaintext(Buffer buffer) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    public static boolean bodyHasUnknownEncoding(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding != null && !"identity".equalsIgnoreCase(contentEncoding) && !"gzip".equalsIgnoreCase(contentEncoding);
    }

    public static String headersString(Headers headers) {
        StringBuilder result = new StringBuilder("{");
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            String name = headers.name(i);
            result.append(name).append(":").append(headers.value(i)).append("; ");
        }
        result.append("}");
        return result.toString();
    }

    private HttpDataUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

