/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jclequinox;

import org.apache.commons.logging.Log;
import org.eclipse.equinox.log.Logger;

final class EquinoxLog
implements Log {
    private static final int LOG_TRACE = 5;
    private final Logger logger;

    EquinoxLog(Logger logger) {
        this.logger = logger;
    }

    public void trace(Object message) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(message.toString());
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.logger.log(5, message.toString(), t);
        }
    }

    public void debug(Object message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message.toString());
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.logger.log(4, message.toString(), t);
        }
    }

    public void info(Object message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message.toString());
        }
    }

    public void info(Object message, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message.toString());
        }
    }

    public void warn(Object message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(message.toString());
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.logger.log(2, message.toString(), t);
        }
    }

    public void error(Object message) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message.toString());
        }
    }

    public void error(Object message, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.log(1, message.toString(), t);
        }
    }

    public void fatal(Object message) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message.toString());
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.log(1, message.toString(), t);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }
}

