/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jclequinox;

import com.github.marschall.jclequinox.EquinoxLog;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class EquinoxLogFactory
extends LogFactory {
    private final Map<String, Object> attributes = Collections.synchronizedMap(new HashMap());
    private final ConcurrentMap<String, Log> loggerMap;
    private final ExtendedLogService logService;

    public EquinoxLogFactory() {
        Bundle bundle = FrameworkUtil.getBundle(EquinoxLogFactory.class);
        if (bundle.getState() == 4) {
            try {
                bundle.start();
            }
            catch (BundleException e) {
                throw new RuntimeException("could not start bundle", e);
            }
        }
        BundleContext context = bundle.getBundleContext();
        ServiceTracker serviceTracker = new ServiceTracker(context, ExtendedLogService.class, null);
        serviceTracker.open();
        context.addBundleListener(event -> {
            if (event.getBundle().getBundleId() == bundle.getBundleId() && event.getType() == 256) {
                serviceTracker.close();
            }
        });
        this.logService = (ExtendedLogService)serviceTracker.getService();
        this.loggerMap = new ConcurrentHashMap<String, Log>();
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        String className = clazz.getName();
        Log slf4jLogger = (Log)this.loggerMap.get(className);
        if (slf4jLogger == null) {
            Bundle bundle = FrameworkUtil.getBundle((Class)clazz);
            Logger equinoxLogger = this.logService.getLogger(bundle, className);
            EquinoxLog newLoggerAdapter = new EquinoxLog(equinoxLogger);
            Log previousLogger = this.loggerMap.putIfAbsent(className, newLoggerAdapter);
            slf4jLogger = previousLogger == null ? newLoggerAdapter : previousLogger;
        }
        return slf4jLogger;
    }

    public Log getInstance(String name) throws LogConfigurationException {
        Log slf4jLogger = (Log)this.loggerMap.get(name);
        if (slf4jLogger == null) {
            Logger equinoxLogger = this.logService.getLogger(name);
            EquinoxLog newLoggerAdapter = new EquinoxLog(equinoxLogger);
            Log previousLogger = this.loggerMap.putIfAbsent(name, newLoggerAdapter);
            slf4jLogger = previousLogger == null ? newLoggerAdapter : previousLogger;
        }
        return slf4jLogger;
    }

    public void release() {
        this.loggerMap.clear();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[0]);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }
}

