/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.template.SpringBootDocBuildTemplate;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;

public class AdocDocBuilder {
    private static final String API_EXTENSION = "Api.adoc";
    private static final String INDEX_DOC = "index.adoc";

    public static void builderApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        AdocDocBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        config.setAdoc(true);
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        SpringBootDocBuildTemplate docBuildTemplate = new SpringBootDocBuildTemplate();
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        if (config.isAllInOne()) {
            builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "AllInOne.adoc", INDEX_DOC);
        } else {
            builderTemplate.buildApiDoc(apiDocList, config, "ApiDoc.adoc", API_EXTENSION);
            builderTemplate.buildErrorCodeDoc(config, "ErrorCodeList.btl", "ErrorCodeList.md");
        }
    }

    public static void buildSingleApiDoc(ApiConfig config, String controllerName) {
        config.setAdoc(false);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, new JavaProjectBuilder());
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        builderTemplate.buildSingleApi(configBuilder, controllerName, "ApiDoc.adoc", API_EXTENSION);
    }
}

