/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.CollectionUtil;
import com.power.common.util.DateTimeUtil;
import com.power.common.util.FileUtil;
import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.DocGlobalConstants;
import com.power.doc.constants.DocLanguage;
import com.power.doc.constants.TemplateVariable;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiDocDict;
import com.power.doc.model.ApiErrorCode;
import com.power.doc.template.SpringBootDocBuildTemplate;
import com.power.doc.utils.BeetlTemplateUtil;
import com.power.doc.utils.MarkDownUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;
import org.beetl.core.Template;

public class HtmlApiDocBuilder {
    private static long now = System.currentTimeMillis();
    private static String INDEX_HTML = "index.html";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        HtmlApiDocBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        SpringBootDocBuildTemplate docBuildTemplate = new SpringBootDocBuildTemplate();
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        if (config.isAllInOne()) {
            Template indexCssTemplate = BeetlTemplateUtil.getByName("AllInOne.css");
            FileUtil.nioWriteFile((String)indexCssTemplate.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "AllInOne.css"));
            builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "AllInOne.html", INDEX_HTML);
        } else {
            List<ApiDocDict> apiDocDictList = builderTemplate.buildDictionary(config, javaProjectBuilder);
            HtmlApiDocBuilder.buildIndex(apiDocList, config);
            HtmlApiDocBuilder.copyCss(config.getOutPath());
            HtmlApiDocBuilder.buildDoc(apiDocList, config.getOutPath());
            HtmlApiDocBuilder.buildErrorCodeDoc(config.getErrorCodes(), config.getOutPath());
            HtmlApiDocBuilder.buildDictionary(apiDocDictList, config.getOutPath());
        }
    }

    private static void copyCss(String outPath) {
        Template indexCssTemplate = BeetlTemplateUtil.getByName("index.css");
        Template mdCssTemplate = BeetlTemplateUtil.getByName("markdown.css");
        FileUtil.nioWriteFile((String)indexCssTemplate.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + "index.css"));
        FileUtil.nioWriteFile((String)mdCssTemplate.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + "markdown.css"));
    }

    private static void buildIndex(List<ApiDoc> apiDocList, ApiConfig config) {
        FileUtil.mkdirs((String)config.getOutPath());
        Template indexTemplate = BeetlTemplateUtil.getByName("Index.btl");
        if (CollectionUtil.isEmpty(apiDocList)) {
            return;
        }
        ApiDoc doc = apiDocList.get(0);
        String homePage = doc.getAlias();
        indexTemplate.binding(TemplateVariable.HOME_PAGE.getVariable(), (Object)homePage);
        indexTemplate.binding(TemplateVariable.API_DOC_LIST.getVariable(), apiDocList);
        indexTemplate.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
        indexTemplate.binding(TemplateVariable.ERROR_CODE_LIST.getVariable(), config.getErrorCodes());
        indexTemplate.binding(TemplateVariable.DICT_LIST.getVariable(), config.getDataDictionaries());
        if (CollectionUtil.isEmpty(config.getErrorCodes())) {
            indexTemplate.binding(TemplateVariable.DICT_ORDER.getVariable(), (Object)(apiDocList.size() + 1));
        } else {
            indexTemplate.binding(TemplateVariable.DICT_ORDER.getVariable(), (Object)(apiDocList.size() + 2));
        }
        if (null != config.getLanguage()) {
            if (DocLanguage.CHINESE.code.equals(config.getLanguage().getCode())) {
                indexTemplate.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"\u9519\u8bef\u7801\u5217\u8868");
                indexTemplate.binding(TemplateVariable.DICT_LIST_TITLE.getVariable(), (Object)"\u6570\u636e\u5b57\u5178");
            } else {
                indexTemplate.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"Error Code List");
                indexTemplate.binding(TemplateVariable.DICT_LIST_TITLE.getVariable(), (Object)"Data Dictionaries");
            }
        } else {
            indexTemplate.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"\u9519\u8bef\u7801\u5217\u8868");
            indexTemplate.binding(TemplateVariable.DICT_LIST_TITLE.getVariable(), (Object)"\u6570\u636e\u5b57\u5178");
        }
        FileUtil.nioWriteFile((String)indexTemplate.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "api.html"));
    }

    private static void buildDoc(List<ApiDoc> apiDocList, String outPath) {
        FileUtil.mkdirs((String)outPath);
        String strTime = DateTimeUtil.long2Str((long)now, (String)"yyyy-MM-dd HH:mm:ss");
        for (ApiDoc doc : apiDocList) {
            Template apiTemplate = BeetlTemplateUtil.getByName("ApiDoc.btl");
            apiTemplate.binding(TemplateVariable.DESC.getVariable(), (Object)doc.getDesc());
            apiTemplate.binding(TemplateVariable.NAME.getVariable(), (Object)doc.getName());
            apiTemplate.binding(TemplateVariable.LIST.getVariable(), doc.getList());
            String html = MarkDownUtil.toHtml(apiTemplate.render());
            Template htmlApiDoc = BeetlTemplateUtil.getByName("HtmlApiDoc.btl");
            htmlApiDoc.binding(TemplateVariable.HTML.getVariable(), (Object)html);
            htmlApiDoc.binding(TemplateVariable.TITLE.getVariable(), (Object)doc.getDesc());
            htmlApiDoc.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)strTime);
            htmlApiDoc.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
            FileUtil.nioWriteFile((String)htmlApiDoc.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + doc.getAlias() + ".html"));
        }
    }

    private static void buildErrorCodeDoc(List<ApiErrorCode> errorCodeList, String outPath) {
        if (CollectionUtil.isNotEmpty(errorCodeList)) {
            Template error = BeetlTemplateUtil.getByName("ErrorCodeList.btl");
            error.binding(TemplateVariable.LIST.getVariable(), errorCodeList);
            String errorHtml = MarkDownUtil.toHtml(error.render());
            Template errorCodeDoc = BeetlTemplateUtil.getByName("HtmlApiDoc.btl");
            errorCodeDoc.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
            errorCodeDoc.binding(TemplateVariable.TITLE.getVariable(), (Object)"Error Code List");
            errorCodeDoc.binding(TemplateVariable.HTML.getVariable(), (Object)errorHtml);
            errorCodeDoc.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)DateTimeUtil.long2Str((long)now, (String)"yyyy-MM-dd HH:mm:ss"));
            FileUtil.nioWriteFile((String)errorCodeDoc.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + "error_code.html"));
        }
    }

    private static void buildDictionary(List<ApiDocDict> apiDocDictList, String outPath) {
        if (CollectionUtil.isNotEmpty(apiDocDictList)) {
            Template template = BeetlTemplateUtil.getByName("Dictionary.btl");
            template.binding(TemplateVariable.DICT_LIST.getVariable(), apiDocDictList);
            String dictHtml = MarkDownUtil.toHtml(template.render());
            Template dictTpl = BeetlTemplateUtil.getByName("HtmlApiDoc.btl");
            dictTpl.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
            dictTpl.binding(TemplateVariable.TITLE.getVariable(), (Object)"Data Dictionaries");
            dictTpl.binding(TemplateVariable.HTML.getVariable(), (Object)dictHtml);
            dictTpl.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)DateTimeUtil.long2Str((long)now, (String)"yyyy-MM-dd HH:mm:ss"));
            FileUtil.nioWriteFile((String)dictTpl.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + "dict.html"));
        }
    }
}

