/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.StringUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.impl.DefaultJavaField;
import com.thoughtworks.qdox.model.impl.DefaultJavaParameterizedType;
import java.util.ArrayList;
import java.util.List;

public class JavaClassUtil {
    public static List<JavaField> getFields(JavaClass cls1, int i) {
        ArrayList<JavaField> fieldList = new ArrayList<JavaField>();
        if (null == cls1) {
            return fieldList;
        }
        if ("Object".equals(cls1.getSimpleName()) || "Timestamp".equals(cls1.getSimpleName()) || "Date".equals(cls1.getSimpleName()) || "Locale".equals(cls1.getSimpleName())) {
            return fieldList;
        }
        String className = cls1.getFullyQualifiedName();
        if (cls1.isInterface() && !JavaClassValidateUtil.isCollection(className) && !JavaClassValidateUtil.isMap(className)) {
            List methods = cls1.getMethods();
            for (JavaMethod javaMethod : methods) {
                String methodName = javaMethod.getName();
                if (!methodName.startsWith("get")) continue;
                methodName = StringUtil.firstToLowerCase((String)methodName.substring(3, methodName.length()));
                DefaultJavaField javaField = new DefaultJavaField(javaMethod.getReturns(), methodName);
                fieldList.add((JavaField)javaField);
            }
        }
        JavaClass pcls = cls1.getSuperJavaClass();
        fieldList.addAll(JavaClassUtil.getFields(pcls, i));
        fieldList.addAll(cls1.getFields());
        return fieldList;
    }

    public static Object getEnumValue(JavaClass javaClass, boolean formDataEnum) {
        List javaFields = javaClass.getEnumConstants();
        List methodList = javaClass.getMethods();
        int annotation = 0;
        for (JavaMethod method : methodList) {
            if (method.getAnnotations().size() <= 0) continue;
            annotation = 1;
            break;
        }
        String value = null;
        int index = 0;
        for (JavaField javaField : javaFields) {
            String simpleName = javaField.getType().getSimpleName();
            StringBuilder valueBuilder = new StringBuilder();
            valueBuilder.append("\"").append(javaField.getName()).append("\"").toString();
            if (formDataEnum) {
                value = valueBuilder.toString();
                return value;
            }
            if (!JavaClassValidateUtil.isPrimitive(simpleName) && index < 1) {
                value = null != javaField.getEnumConstantArguments() && annotation > 0 ? javaField.getEnumConstantArguments().get(0) : valueBuilder.toString();
            }
            ++index;
        }
        return value;
    }

    public static String getAnnotationSimpleName(String annotationName) {
        return JavaClassUtil.getClassSimpleName(annotationName);
    }

    public static String getClassSimpleName(String className) {
        if (className.contains(".")) {
            int index = className.lastIndexOf(".");
            className = className.substring(index + 1, className.length());
        }
        return className;
    }

    public static JavaClass getActualType(JavaClass javaClass) {
        return JavaClassUtil.getActualTypes(javaClass).get(0);
    }

    public static List<JavaClass> getActualTypes(JavaClass javaClass) {
        if (null == javaClass) {
            return new ArrayList<JavaClass>(0);
        }
        ArrayList<JavaClass> javaClassList = new ArrayList<JavaClass>();
        List actualTypes = ((DefaultJavaParameterizedType)javaClass).getActualTypeArguments();
        actualTypes.forEach(javaType -> {
            JavaClass actualClass = (JavaClass)javaType;
            javaClassList.add(actualClass);
        });
        return javaClassList;
    }
}

