/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder.rpc;

import com.power.common.util.CollectionUtil;
import com.power.common.util.DateTimeUtil;
import com.power.common.util.FileUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.builder.rpc.RpcDocBuilderTemplate;
import com.power.doc.constants.DocGlobalConstants;
import com.power.doc.constants.DocLanguage;
import com.power.doc.constants.TemplateVariable;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiErrorCode;
import com.power.doc.model.rpc.RpcApiDependency;
import com.power.doc.model.rpc.RpcApiDoc;
import com.power.doc.template.RpcDocBuildTemplate;
import com.power.doc.utils.BeetlTemplateUtil;
import com.power.doc.utils.MarkDownUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;
import java.util.Objects;
import org.beetl.core.Template;

public class RpcHtmlBuilder {
    private static long now = System.currentTimeMillis();
    private static String INDEX_HTML = "rpc-index.html";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        RpcHtmlBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        config.setShowJavaType(true);
        RpcDocBuilderTemplate builderTemplate = new RpcDocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        builderTemplate.checkAndInit(config);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        RpcDocBuildTemplate docBuildTemplate = new RpcDocBuildTemplate();
        List<RpcApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        if (config.isAllInOne()) {
            Template indexCssTemplate = BeetlTemplateUtil.getByName("AllInOne.css");
            FileUtil.nioWriteFile((String)indexCssTemplate.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "AllInOne.css"));
            builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "dubbo/DubboAllInOne.html", INDEX_HTML);
        } else {
            RpcHtmlBuilder.buildIndex(apiDocList, config);
            RpcHtmlBuilder.copyCss(config.getOutPath());
            RpcHtmlBuilder.buildDoc(apiDocList, config.getOutPath());
            RpcHtmlBuilder.buildErrorCodeDoc(config.getErrorCodes(), config.getOutPath());
            RpcHtmlBuilder.buildDependency(config);
        }
    }

    private static void copyCss(String outPath) {
        Template indexCssTemplate = BeetlTemplateUtil.getByName("index.css");
        Template mdCssTemplate = BeetlTemplateUtil.getByName("markdown.css");
        FileUtil.nioWriteFile((String)indexCssTemplate.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + "index.css"));
        FileUtil.nioWriteFile((String)mdCssTemplate.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + "markdown.css"));
    }

    private static void buildIndex(List<RpcApiDoc> apiDocList, ApiConfig config) {
        FileUtil.mkdirs((String)config.getOutPath());
        Template indexTemplate = BeetlTemplateUtil.getByName("dubbo/DubboIndex.btl");
        if (CollectionUtil.isEmpty(apiDocList)) {
            return;
        }
        RpcApiDoc doc = apiDocList.get(0);
        String homePage = doc.getAlias();
        indexTemplate.binding(TemplateVariable.HOME_PAGE.getVariable(), (Object)homePage);
        indexTemplate.binding(TemplateVariable.API_DOC_LIST.getVariable(), apiDocList);
        indexTemplate.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
        indexTemplate.binding(TemplateVariable.ERROR_CODE_LIST.getVariable(), config.getErrorCodes());
        indexTemplate.binding(TemplateVariable.DICT_LIST.getVariable(), config.getDataDictionaries());
        if (CollectionUtil.isEmpty(config.getErrorCodes())) {
            indexTemplate.binding(TemplateVariable.DICT_ORDER.getVariable(), (Object)(apiDocList.size() + 2));
        } else {
            indexTemplate.binding(TemplateVariable.DICT_ORDER.getVariable(), (Object)(apiDocList.size() + 3));
        }
        if (null != config.getLanguage()) {
            if (DocLanguage.CHINESE.code.equals(config.getLanguage().getCode())) {
                indexTemplate.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"\u9519\u8bef\u7801\u5217\u8868");
            } else {
                indexTemplate.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"Error Code List");
            }
        } else {
            indexTemplate.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"\u9519\u8bef\u7801\u5217\u8868");
        }
        FileUtil.nioWriteFile((String)indexTemplate.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "rpc-api.html"));
    }

    private static void buildDoc(List<RpcApiDoc> apiDocList, String outPath) {
        FileUtil.mkdirs((String)outPath);
        String strTime = DateTimeUtil.long2Str((long)now, (String)"yyyy-MM-dd HH:mm:ss");
        for (RpcApiDoc rpcDoc : apiDocList) {
            Template apiTemplate = BeetlTemplateUtil.getByName("dubbo/Dubbo.md");
            apiTemplate.binding(TemplateVariable.DESC.getVariable(), (Object)rpcDoc.getDesc());
            apiTemplate.binding(TemplateVariable.NAME.getVariable(), (Object)rpcDoc.getName());
            apiTemplate.binding(TemplateVariable.LIST.getVariable(), rpcDoc.getList());
            apiTemplate.binding(TemplateVariable.PROTOCOL.getVariable(), (Object)rpcDoc.getProtocol());
            apiTemplate.binding(TemplateVariable.AUTHOR.getVariable(), (Object)rpcDoc.getAuthor());
            apiTemplate.binding(TemplateVariable.VERSION.getVariable(), (Object)rpcDoc.getVersion());
            apiTemplate.binding(TemplateVariable.URI.getVariable(), (Object)rpcDoc.getUri());
            String html = MarkDownUtil.toHtml(apiTemplate.render());
            Template htmlApiDoc = BeetlTemplateUtil.getByName("HtmlApiDoc.btl");
            htmlApiDoc.binding(TemplateVariable.HTML.getVariable(), (Object)html);
            htmlApiDoc.binding(TemplateVariable.TITLE.getVariable(), (Object)rpcDoc.getDesc());
            htmlApiDoc.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)strTime);
            htmlApiDoc.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
            FileUtil.nioWriteFile((String)htmlApiDoc.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + rpcDoc.getShortName() + ".html"));
        }
    }

    private static void buildErrorCodeDoc(List<ApiErrorCode> errorCodeList, String outPath) {
        if (CollectionUtil.isNotEmpty(errorCodeList)) {
            Template error = BeetlTemplateUtil.getByName("ErrorCodeList.btl");
            error.binding(TemplateVariable.LIST.getVariable(), errorCodeList);
            String errorHtml = MarkDownUtil.toHtml(error.render());
            Template errorCodeDoc = BeetlTemplateUtil.getByName("HtmlApiDoc.btl");
            errorCodeDoc.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
            errorCodeDoc.binding(TemplateVariable.HTML.getVariable(), (Object)errorHtml);
            errorCodeDoc.binding(TemplateVariable.TITLE.getVariable(), (Object)"Error Code List");
            errorCodeDoc.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)DateTimeUtil.long2Str((long)now, (String)"yyyy-MM-dd HH:mm:ss"));
            FileUtil.nioWriteFile((String)errorCodeDoc.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + "error_code.html"));
        }
    }

    private static void buildDependency(ApiConfig config) {
        Template template;
        List<RpcApiDependency> apiDependencies = config.getRpcApiDependencies();
        if (CollectionUtil.isNotEmpty(config.getRpcApiDependencies())) {
            String rpcConfig = config.getRpcConsumerConfig();
            String rpcConfigConfigContent = null;
            if (Objects.nonNull(rpcConfig)) {
                rpcConfigConfigContent = FileUtil.getFileContent((String)rpcConfig);
            }
            template = BeetlTemplateUtil.getByName("dubbo/DubboApiDependency.md");
            template.binding(TemplateVariable.RPC_CONSUMER_CONFIG.getVariable(), (Object)rpcConfigConfigContent);
            template.binding(TemplateVariable.DEPENDENCY_LIST.getVariable(), apiDependencies);
        } else {
            template = BeetlTemplateUtil.getByName("dubbo/DubboApiDependencyEmpty.md");
        }
        String dictHtml = MarkDownUtil.toHtml(template.render());
        Template dictTpl = BeetlTemplateUtil.getByName("HtmlApiDoc.btl");
        dictTpl.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
        dictTpl.binding(TemplateVariable.TITLE.getVariable(), (Object)"Data Dictionaries");
        dictTpl.binding(TemplateVariable.HTML.getVariable(), (Object)dictHtml);
        dictTpl.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)DateTimeUtil.long2Str((long)now, (String)"yyyy-MM-dd HH:mm:ss"));
        FileUtil.nioWriteFile((String)dictTpl.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "dependency.html"));
    }
}

