/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.power.common.util.FileUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.TemplateVariable;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiParam;
import com.power.doc.template.SpringBootDocBuildTemplate;
import com.power.doc.utils.BeetlTemplateUtil;
import com.power.doc.utils.Iterables;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.beetl.core.Template;

public class YapiJsonBuilder {
    public static void buildYapiCollection(ApiConfig config) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        YapiJsonBuilder.yapiJsonCreate(config, configBuilder);
    }

    public static void buildYapiCollection(ApiConfig config, JavaProjectBuilder projectBuilder) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, projectBuilder);
        YapiJsonBuilder.yapiJsonCreate(config, configBuilder);
    }

    private static Set<String> getUrl(String url, String patter) {
        Pattern pattern = Pattern.compile(patter);
        Matcher matcher = pattern.matcher(url);
        HashSet<String> result = new HashSet<String>();
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result;
    }

    private static void yapiJsonCreate(ApiConfig config, ProjectDocConfigBuilder configBuilder) {
        config.setParamsDataToTree(true);
        SpringBootDocBuildTemplate docBuildTemplate = new SpringBootDocBuildTemplate();
        List apiDocList = docBuildTemplate.getApiData(configBuilder);
        ArrayList requestItem = new ArrayList();
        Iterables.forEach(apiDocList, (index, apiDoc) -> {
            HashMap<String, Object> module = new HashMap<String, Object>();
            module.put("index", index);
            module.put("name", apiDoc.getDesc());
            module.put("parent_id", -1);
            module.put("desc", apiDoc.getDesc());
            module.put("add_time", System.currentTimeMillis() / 1000L);
            module.put("up_time", System.currentTimeMillis() / 1000L);
            ArrayList methods = new ArrayList();
            Iterables.forEach(apiDoc.getList(), (idx, apiMethodDoc) -> {
                HashMap<String, Object> method = new HashMap<String, Object>();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("path", apiMethodDoc.getPath());
                map.put("params", new Object[0]);
                method.put("query_path", map);
                method.put("owners", new String[0]);
                method.put("edit_uid", 0);
                method.put("status", "done");
                method.put("type", "static");
                method.put("req_body_is_json_schema", true);
                method.put("res_body_is_json_schema", true);
                method.put("api_opened", false);
                method.put("index", idx);
                method.put("tag", new Object[0]);
                method.put("method", apiMethodDoc.getType());
                method.put("title", apiMethodDoc.getDesc());
                method.put("desc", apiMethodDoc.getDetail());
                method.put("name", apiMethodDoc.getName());
                method.put("path", apiMethodDoc.getPath().replace("//", "/"));
                method.put("req_body_form", Arrays.asList(new Object[0]));
                ArrayList req_params = new ArrayList();
                Set<String> req_param = YapiJsonBuilder.getUrl(apiMethodDoc.getPath(), "(?<=\\{)(.+?)(?=\\})");
                Iterables.forEach(req_param, (j, param) -> {
                    ApiParam temp = apiMethodDoc.getRequestParams().stream().filter(apiParam -> apiParam.getField().equals(param)).findFirst().orElse(null);
                    if (temp != null) {
                        HashMap<String, String> h = new HashMap<String, String>();
                        h.put("example", "");
                        h.put("name", temp.getField());
                        h.put("type", temp.getType());
                        h.put("desc", temp.getDesc());
                        req_params.add((int)j, h);
                    }
                });
                method.put("req_params", req_params);
                method.put("res_body_type", "json");
                ArrayList querys = new ArrayList();
                Iterables.forEach(apiMethodDoc.getRequestParams(), (j, res) -> {
                    HashMap<String, String> h = new HashMap<String, String>();
                    h.put("required", res.isRequired() ? "1" : "0");
                    h.put("desc", res.getDesc());
                    h.put("name", res.getField());
                    h.put("example", "");
                    h.put("type", res.getType());
                    querys.add((int)j, h);
                });
                method.put("req_query", querys);
                ArrayList headers = new ArrayList();
                Iterables.forEach(apiMethodDoc.getRequestHeaders(), (j, res) -> {
                    HashMap<String, String> h = new HashMap<String, String>();
                    h.put("required", res.isRequired() ? "1" : "0");
                    h.put("value", res.getValue());
                    h.put("name", res.getName());
                    h.put("desc", res.getDesc());
                    headers.add((int)j, h);
                });
                method.put("req_headers", headers);
                Template apiTemplate = BeetlTemplateUtil.getByName("yapiJson.btl");
                apiTemplate.binding(TemplateVariable.RESPONSE_LIST.getVariable(), (Object)YapiJsonBuilder.generateJson(apiMethodDoc.getResponseParams()));
                String json = apiTemplate.render();
                method.put("res_body", json);
                if (StringUtil.isNotEmpty((String)apiMethodDoc.getResponseUsage())) {
                    method.put("desc", "<pre><code>\n" + apiMethodDoc.getResponseUsage() + "\n</code></pre>\n");
                }
                methods.add((int)idx, method);
            });
            module.put("list", methods);
            requestItem.add(module);
        });
        String filePath = config.getOutPath();
        filePath = filePath + "/yapi.json";
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String data = gson.toJson(requestItem);
        FileUtil.nioWriteFile((String)data, (String)filePath);
    }

    private static String generateJson(List<ApiParam> responseParams) {
        StringBuffer re = new StringBuffer("\"type\":\"object\",\n\"properties\":{\n");
        HashSet required = new HashSet();
        responseParams.stream().forEach(apiParam -> {
            re.append(YapiJsonBuilder.getTypeAndPropertiesJson(apiParam));
            if (apiParam.isRequired()) {
                required.add(apiParam.getField());
            }
        });
        Gson gs = new Gson();
        re.append("\"required\":\"" + gs.toJson((Object)required.toArray()) + "\"");
        re.append("\t}");
        return re.toString();
    }

    private static String changeType(String type) {
        switch (type) {
            case "boolean": {
                return "boolean";
            }
            case "int32": {
                return "integer";
            }
            case "int64": {
                return "number";
            }
        }
        return type;
    }

    private static String getTypeAndPropertiesJson(ApiParam param) {
        StringBuffer resultJson = new StringBuffer();
        resultJson.append("\"" + param.getField() + "\":{");
        resultJson.append("\"type\":\"" + YapiJsonBuilder.changeType(param.getType()) + "\",   ");
        if (param.getChildren() != null && param.getChildren().size() > 0) {
            if (param.getType().equals("object")) {
                resultJson.append(" \"properties\":{");
                param.getChildren().forEach(child -> resultJson.append(YapiJsonBuilder.getTypeAndPropertiesJson(child)));
            } else if (param.getType().equals("array")) {
                resultJson.append(" \"items\":{");
                resultJson.append("\"type\":\"object\",\n\"properties\":{\n");
                param.getChildren().forEach(child -> resultJson.append(YapiJsonBuilder.getTypeAndPropertiesJson(child)));
                resultJson.append("\t},");
            }
            resultJson.append("},");
        }
        resultJson.append("},");
        return resultJson.toString();
    }
}

