/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.MediaQuery;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class Import
extends ASTCssNode {
    private ImportMultiplicity multiplicity = ImportMultiplicity.IMPORT;
    private ImportContent contentKind = ImportContent.SUFFIX_BASED;
    private boolean isInline = false;
    private boolean isReferenceOnly = false;
    private boolean isOptional = false;
    private Expression urlExpression;
    private List<MediaQuery> mediums = new ArrayList<MediaQuery>();

    public Import(HiddenTokenAwareTree underlyingStructure) {
        super(underlyingStructure);
    }

    public boolean isReferenceOnly() {
        return this.isReferenceOnly;
    }

    public void setReferenceOnly(boolean isReferenceOnly) {
        this.isReferenceOnly = isReferenceOnly;
    }

    public boolean isInline() {
        return this.isInline;
    }

    public void setInline(boolean isInline) {
        this.isInline = isInline;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    public ImportContent getContentKind() {
        return this.contentKind;
    }

    public void setContentKind(ImportContent contentKind) {
        this.contentKind = contentKind;
    }

    public ImportMultiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(ImportMultiplicity multiplicity) {
        this.multiplicity = multiplicity;
    }

    public Expression getUrlExpression() {
        return this.urlExpression;
    }

    public void setUrlExpression(Expression urlExpression) {
        this.urlExpression = urlExpression;
    }

    public List<MediaQuery> getMediums() {
        return this.mediums;
    }

    public void setMediums(List<MediaQuery> mediums) {
        this.mediums = mediums;
    }

    public void add(MediaQuery medium) {
        this.mediums.add(medium);
    }

    public boolean hasMediums() {
        return !this.mediums.isEmpty();
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.urlExpression);
        result.addAll(this.mediums);
        return result;
    }

    @Override
    public Import clone() {
        Import result = (Import)super.clone();
        result.urlExpression = this.urlExpression == null ? null : this.urlExpression.clone();
        result.mediums = ArraysUtils.deeplyClonedList(this.mediums);
        result.configureParentToAllChilds();
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.IMPORT;
    }

    public static enum ImportContent {
        LESS,
        CSS,
        SUFFIX_BASED;

    }

    public static enum ImportMultiplicity {
        IMPORT,
        IMPORT_ONCE,
        IMPORT_MULTIPLE;

    }
}

