/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.selectors;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.Extend;
import com.github.sommeri.less4j.core.ast.NestedSelectorAppender;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class SelectorsManipulator {
    public List<Selector> replaceAppenders(Selector inSelector, List<Selector> replacements) {
        if (!inSelector.containsAppender()) {
            return this.indirectJoinAll(replacements, null, inSelector);
        }
        List<Selector> result = Arrays.asList(inSelector);
        while (result.get(0).containsAppender()) {
            ArrayList<Selector> nextRound = new ArrayList<Selector>();
            for (Selector tbch : result) {
                nextRound.addAll(this.replaceFirstAppender(tbch, replacements));
            }
            result = nextRound;
        }
        return result;
    }

    private List<Selector> indirectJoinAll(List<Selector> first, SelectorCombinator combinator, Selector second) {
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector previous : first) {
            result.add(this.indirectJoin(previous, combinator, second));
        }
        return result;
    }

    public Selector indirectJoin(Selector firstI, SelectorCombinator combinator, Selector secondI) {
        if (secondI == null) {
            return firstI.clone();
        }
        if (firstI == null) {
            return secondI.clone();
        }
        Selector first = firstI.clone();
        Selector second = secondI.clone();
        return this.indirectJoinNoClone(first, combinator, second);
    }

    public Selector indirectJoinNoClone(Selector first, SelectorCombinator combinator, Selector second) {
        return this.indirectJoinNoClone(first, combinator, second.getParts(), second.getExtend());
    }

    public Selector indirectJoinNoClone(Selector first, SelectorCombinator combinator, List<SelectorPart> second, List<Extend> extend) {
        first.addExtends(extend);
        if (second.isEmpty()) {
            return first;
        }
        if (combinator != null) {
            second.get(0).setLeadingCombinator(combinator);
        }
        first.addParts(second);
        first.configureParentToAllChilds();
        return first;
    }

    public Selector directJoin(Selector firstI, Selector secondI) {
        if (secondI == null) {
            return firstI.clone();
        }
        if (firstI == null) {
            return secondI.clone();
        }
        Selector first = firstI.clone();
        List<SelectorPart> secondParts = ArraysUtils.deeplyClonedList(secondI.getParts());
        List<Extend> secondExtends = ArraysUtils.deeplyClonedList(secondI.getExtend());
        SelectorPart secondHead = secondParts.get(0);
        if (secondHead.isAppender()) {
            return this.indirectJoinNoClone(first, secondHead.getLeadingCombinator(), secondParts, secondExtends);
        }
        SelectorPart attachToHead = first.getLastPart();
        this.directlyJoinParts(attachToHead, secondHead);
        secondParts.remove(0);
        SelectorCombinator leadingCombinator = secondParts.isEmpty() ? null : secondParts.get(0).getLeadingCombinator();
        return this.indirectJoinNoClone(first, leadingCombinator, secondParts, secondExtends);
    }

    public void directlyJoinParts(SelectorPart first, SelectorPart second) {
        if (second.hasElement()) {
            String secondName;
            String string = secondName = second.hasElement() ? second.getElementName().getName() : "";
            if (first.hasSubsequent()) {
                ElementSubsequent subsequent = first.getLastSubsequent();
                subsequent.extendName(secondName);
            } else {
                first.extendName(secondName, second.getUnderlyingStructure());
            }
        }
        first.addSubsequent(second.getSubsequent());
        first.configureParentToAllChilds();
    }

    private Collection<Selector> replaceFirstAppender(Selector selector, List<Selector> previousSelectors) {
        if (selector.getHead().isAppender()) {
            NestedSelectorAppender appender = (NestedSelectorAppender)selector.getHead();
            return this.joinAll(previousSelectors, this.chopOffHead(selector), appender.getLeadingCombinator(), appender.isDirectlyBefore());
        }
        NestedSelectorAppender appender = selector.findFirstAppender();
        if (appender == null) {
            throw new BugHappened("This is very weird error and should not happen.", (ASTCssNode)selector);
        }
        Selector afterAppender = this.splitOn(selector, appender);
        List<Selector> partialResults = this.joinAll(selector, previousSelectors, appender.getLeadingCombinator(), appender.isDirectlyAfter());
        return this.joinAll(partialResults, afterAppender, null, appender.isDirectlyBefore());
    }

    private List<Selector> joinAll(Selector first, List<Selector> seconds, SelectorCombinator leadingCombinator, boolean appenderDirectlyPlaced) {
        boolean directJoin = this.isDirect(leadingCombinator, appenderDirectlyPlaced, null);
        if (directJoin) {
            return this.directJoinAll(first, seconds);
        }
        return this.indirectJoinAll(leadingCombinator, first, seconds);
    }

    private List<Selector> joinAll(List<Selector> firsts, Selector second, SelectorCombinator beforeAppenderCombinator, boolean appenderDirectlyPlaced) {
        boolean directJoin = this.isDirect(beforeAppenderCombinator, appenderDirectlyPlaced, second);
        if (directJoin) {
            return this.directJoinAll(firsts, second);
        }
        return this.indirectJoinAll(firsts, beforeAppenderCombinator, second);
    }

    private Selector chopOffHead(Selector selector) {
        if (!selector.isCombined()) {
            return null;
        }
        selector.removeHead();
        return selector;
    }

    private List<Selector> directJoinAll(List<Selector> firsts, Selector second) {
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector first : firsts) {
            result.add(this.directJoin(first, second));
        }
        return result;
    }

    private List<Selector> indirectJoinAll(SelectorCombinator leadingCombinator, Selector first, List<Selector> seconds) {
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector second : seconds) {
            result.add(this.indirectJoin(first, leadingCombinator, second));
        }
        return result;
    }

    private List<Selector> directJoinAll(Selector first, List<Selector> seconds) {
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector second : seconds) {
            result.add(this.directJoin(first, second));
        }
        return result;
    }

    private boolean isDirect(SelectorCombinator beforeAppenderCombinator, boolean appenderDirectlyPlaced, Selector afterAppender) {
        return beforeAppenderCombinator == null && appenderDirectlyPlaced && (afterAppender == null || !afterAppender.hasLeadingCombinator());
    }

    private Selector splitOn(Selector selector, NestedSelectorAppender appender) {
        List<SelectorPart> parts = selector.getParts();
        int indexOfAppender = parts.indexOf(appender);
        List<SelectorPart> appenderAndAfter = parts.subList(indexOfAppender, parts.size());
        appenderAndAfter.remove(0);
        appender.setParent(null);
        Selector result = null;
        if (!appenderAndAfter.isEmpty()) {
            result = new Selector(selector.getUnderlyingStructure(), new ArrayList<SelectorPart>(appenderAndAfter));
            result.configureParentToAllChilds();
        }
        appenderAndAfter.clear();
        return result;
    }
}

