/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.Directive;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.compiler.stages.AstLogic;
import com.github.sommeri.less4j.core.compiler.stages.BodiesStorage;
import com.github.sommeri.less4j.core.compiler.stages.NestedMediaCollector;
import com.github.sommeri.less4j.core.compiler.stages.ParentChainIterator;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.List;

public class DirectiveBubblerAndMerger {
    private ASTManipulator astManipulator = new ASTManipulator();
    private ProblemsHandler problemsHandler;

    public DirectiveBubblerAndMerger(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public void bubbleAndMergeMedia(StyleSheet node) {
        this.bubbleUp(node);
        this.mergeTopLevelMedias(node);
    }

    private void mergeTopLevelMedias(Body node) {
        NestedMediaCollector nestedMediaCollector = new NestedMediaCollector(this.problemsHandler);
        ArrayList<ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        block3: for (ASTCssNode kid : childs) {
            switch (kid.getType()) {
                case MEDIA: {
                    List<Media> nestedMedia = nestedMediaCollector.collectMedia((Media)kid);
                    this.astManipulator.addIntoBody(nestedMedia, kid);
                    continue block3;
                }
            }
            if (!(kid instanceof Directive) || !AstLogic.isBubleableDirective(kid)) continue;
            Directive directive = (Directive)kid;
            this.mergeTopLevelMedias((Body)directive.getBody());
        }
    }

    private void bubbleUp(ASTCssNode node) {
        switch (node.getType()) {
            case RULE_SET: {
                return;
            }
        }
        if (AstLogic.isBubleableDirective(node)) {
            this.bubbleUp((Directive)node);
        }
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode aSTCssNode : childs) {
            this.bubbleUp(aSTCssNode);
        }
    }

    private void bubbleUp(Directive directive) {
        ParentChainIterator parentChainIterator = new ParentChainIterator(directive);
        if (parentChainIterator.finished()) {
            return;
        }
        this.astManipulator.removeFromBody(directive);
        BodiesStorage bodiesStorage = new BodiesStorage();
        Body oldBody = parentChainIterator.getParentAsBody();
        ASTCssNode currentNode = parentChainIterator.getCurrentNode();
        parentChainIterator.moveUpToNextBody();
        Body emptyClone = bodiesStorage.storeAndReplaceBySingleMemberClone(oldBody, null);
        this.astManipulator.moveMembersBetweenBodies((Body)directive.getBody(), emptyClone);
        while (!parentChainIterator.finished()) {
            oldBody = parentChainIterator.getParentAsBody();
            currentNode = parentChainIterator.getCurrentNode();
            parentChainIterator.moveUpToNextBody();
            bodiesStorage.storeAndReplaceBySingleMemberClone(oldBody, currentNode);
        }
        currentNode = parentChainIterator.getCurrentNode();
        ASTCssNode currentNodeClone = currentNode.clone();
        ((GeneralBody)directive.getBody()).addMember(currentNodeClone);
        currentNodeClone.setParent((ASTCssNode)directive.getBody());
        bodiesStorage.restore();
        this.astManipulator.addIntoBody(directive, currentNode);
    }
}

