/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.minify.engine;

import java.util.Objects;
import lombok.NonNull;
import org.thymeleaf.engine.AbstractTemplateHandler;
import org.thymeleaf.engine.TextUtils;
import org.thymeleaf.model.ICloseElementTag;
import org.thymeleaf.model.IComment;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IText;

public abstract class AbstractMinifierTemplateHandler
extends AbstractTemplateHandler {
    protected static final String STYLE = "style";
    protected static final String SCRIPT = "script";
    private boolean removeComments = true;
    private boolean minifyInlineStyle = true;
    private boolean minifyInlineScript = true;
    private boolean insideStyleElements;
    private boolean insideScriptElements;

    public void handleComment(IComment comment) {
        if (!this.removeComments) {
            super.handleComment(comment);
        }
    }

    public void handleText(@NonNull IText text) {
        if (text == null) {
            throw new NullPointerException("text is marked @NonNull but is null");
        }
        String value = text.getText();
        value = this.minifyInlineStyle && this.insideStyleElements ? this.minifyInlineStyle(value) : (this.minifyInlineScript && this.insideScriptElements ? this.minifyInlineScript(value) : this.minifyText(value));
        super.handleText(TextUtils.copy(text, value));
    }

    public void handleOpenElement(@NonNull IOpenElementTag openElementTag) {
        if (openElementTag == null) {
            throw new NullPointerException("openElementTag is marked @NonNull but is null");
        }
        String name = openElementTag.getElementCompleteName();
        if (!this.insideStyleElements && Objects.equals(name, STYLE)) {
            this.insideStyleElements = true;
        } else if (!this.insideScriptElements && Objects.equals(name, SCRIPT)) {
            this.insideScriptElements = true;
        }
        super.handleOpenElement(openElementTag);
    }

    public void handleCloseElement(@NonNull ICloseElementTag closeElementTag) {
        if (closeElementTag == null) {
            throw new NullPointerException("closeElementTag is marked @NonNull but is null");
        }
        String name = closeElementTag.getElementCompleteName();
        if (this.insideStyleElements && Objects.equals(name, STYLE)) {
            this.insideStyleElements = false;
        } else if (this.insideScriptElements && Objects.equals(name, SCRIPT)) {
            this.insideScriptElements = false;
        }
        super.handleCloseElement(closeElementTag);
    }

    protected abstract String minifyInlineStyle(String var1);

    protected abstract String minifyInlineScript(String var1);

    protected abstract String minifyText(String var1);

    protected boolean isRemoveComments() {
        return this.removeComments;
    }

    public AbstractMinifierTemplateHandler setRemoveComments(boolean removeComments) {
        this.removeComments = removeComments;
        return this;
    }

    protected boolean isMinifyInlineStyle() {
        return this.minifyInlineStyle;
    }

    public AbstractMinifierTemplateHandler setMinifyInlineStyle(boolean minifyInlineStyle) {
        this.minifyInlineStyle = minifyInlineStyle;
        return this;
    }

    protected boolean isMinifyInlineScript() {
        return this.minifyInlineScript;
    }

    public AbstractMinifierTemplateHandler setMinifyInlineScript(boolean minifyInlineScript) {
        this.minifyInlineScript = minifyInlineScript;
        return this;
    }

    protected boolean isInsideStyleElements() {
        return this.insideStyleElements;
    }

    protected boolean isInsideScriptElements() {
        return this.insideScriptElements;
    }
}

