/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jetbrick.io.resource.Resource;
import jetbrick.io.resource.ResourceNotFoundException;
import jetbrick.template.JetConfig;
import jetbrick.template.JetEngine;
import jetbrick.template.JetGlobalContext;
import jetbrick.template.JetTemplate;
import jetbrick.template.JetTemplateImpl;
import jetbrick.template.loader.ResourceLoader;
import jetbrick.template.loader.resource.SourceResource;
import jetbrick.template.resolver.GlobalResolver;
import jetbrick.template.runtime.JetForIterator;
import jetbrick.template.runtime.buildin.JetFunctions;
import jetbrick.template.runtime.buildin.JetMethods;
import jetbrick.template.runtime.buildin.JetTags;
import jetbrick.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JetEngineImpl
extends JetEngine {
    private final Logger log = LoggerFactory.getLogger(JetEngineImpl.class);
    private final ConcurrentMap<String, JetTemplate> cache = new ConcurrentHashMap<String, JetTemplate>(128);
    private final JetConfig config;
    private final List<ResourceLoader> loaders;
    private final JetGlobalContext globalContext;
    private final GlobalResolver globalResolver;

    public JetEngineImpl(JetConfig config) {
        this.config = config;
        this.loaders = config.getTemplateLoaders();
        this.log.info("JetEngine.version = {}", (Object)JetEngine.VERSION);
        for (ResourceLoader loader : this.loaders) {
            this.log.info("JetEngine.loader = {}, root = {}, reload = {}", new Object[]{loader.getClass().getName(), loader.getRoot(), loader.isReloadable()});
        }
        this.globalResolver = this.doCreateGlobalResolver();
        this.globalContext = this.doCreateGlobalContext();
        this.doLoadGlobalMacroFiles();
    }

    @Override
    public JetConfig getConfig() {
        return this.config;
    }

    @Override
    public JetGlobalContext getGlobalContext() {
        return this.globalContext;
    }

    @Override
    public GlobalResolver getGlobalResolver() {
        return this.globalResolver;
    }

    @Override
    public boolean checkTemplate(String name) {
        return this.internalGetTemplate(name) != null;
    }

    @Override
    public JetTemplate getTemplate(String name) throws ResourceNotFoundException {
        JetTemplate template = this.internalGetTemplate(name);
        if (template != null) {
            try {
                template.reload();
                return template;
            }
            catch (ResourceNotFoundException e) {
                this.cache.remove(template.getName());
                throw e;
            }
        }
        throw new ResourceNotFoundException(name);
    }

    @Override
    public JetTemplate createTemplate(String source) {
        return this.createTemplate("(source)", source);
    }

    @Override
    public JetTemplate createTemplate(String name, String source) {
        SourceResource resource = new SourceResource(name, source);
        JetTemplateImpl template = new JetTemplateImpl(this, (Resource)resource, false, this.config.getTemplateSecurityManager());
        template.reload();
        return template;
    }

    private JetTemplate internalGetTemplate(String name) {
        if ((name = PathUtils.normalize((String)name)).startsWith("../")) {
            return null;
        }
        JetTemplate template = (JetTemplate)this.cache.get(name);
        if (template != null) {
            return template;
        }
        for (ResourceLoader loader : this.loaders) {
            Resource resource = loader.load(name);
            if (resource == null) continue;
            template = new JetTemplateImpl(this, resource, loader.isReloadable(), loader.getSecurityManager());
            JetTemplate old = this.cache.putIfAbsent(name, template);
            if (old != null) {
                template = old;
            }
            return template;
        }
        return null;
    }

    @Override
    public Resource getResource(String name) throws ResourceNotFoundException {
        if ((name = PathUtils.normalize((String)name)).startsWith("../")) {
            throw new ResourceNotFoundException(name);
        }
        for (ResourceLoader loader : this.loaders) {
            Resource resource = loader.load(name);
            if (resource == null) continue;
            return resource;
        }
        throw new ResourceNotFoundException(name);
    }

    private GlobalResolver doCreateGlobalResolver() {
        this.log.debug("Initializing global resolver ...");
        GlobalResolver resolver = new GlobalResolver();
        resolver.importClass("java.lang.*");
        resolver.importClass("java.util.*");
        for (String className : this.config.getImportClasses()) {
            resolver.importClass(className);
        }
        resolver.registerMethods(JetMethods.class);
        for (String className : this.config.getImportMethods()) {
            resolver.registerMethods(className);
        }
        resolver.registerFunctions(JetFunctions.class);
        for (String className : this.config.getImportFunctions()) {
            resolver.registerFunctions(className);
        }
        resolver.registerTags(JetTags.class);
        for (String className : this.config.getImportTags()) {
            resolver.registerTags(className);
        }
        List<String> packageNames = this.config.getAutoscanPackages();
        if (!packageNames.isEmpty()) {
            resolver.scan(packageNames, this.config.isAutoscanSkiperrors());
        }
        return resolver;
    }

    private JetGlobalContext doCreateGlobalContext() {
        this.log.debug("Initializing global context ...");
        JetGlobalContext ctx = new JetGlobalContext();
        ctx.define(JetForIterator.class, "for");
        for (String define : this.config.getImportDefines()) {
            int pos = define.indexOf(32);
            String type = define.substring(0, pos);
            String name = define.substring(pos + 1);
            Class<?> cls = this.globalResolver.resolveClass(type);
            ctx.define(cls, name);
        }
        return ctx;
    }

    private void doLoadGlobalMacroFiles() {
        List<String> macroFiles = this.config.getImportMacros();
        for (String file : macroFiles) {
            JetTemplate template = this.getTemplate(file);
            this.globalResolver.registerMacros(template);
        }
    }
}

