/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template;

import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import jetbrick.io.resource.Resource;
import jetbrick.io.resource.ResourceNotFoundException;
import jetbrick.template.JetConfig;
import jetbrick.template.JetEngine;
import jetbrick.template.JetSecurityManager;
import jetbrick.template.JetTemplate;
import jetbrick.template.JetTemplateMacro;
import jetbrick.template.JetTemplateOption;
import jetbrick.template.parser.AstBuilder;
import jetbrick.template.parser.ParserContext;
import jetbrick.template.parser.Source;
import jetbrick.template.parser.ast.AstDirectiveMacro;
import jetbrick.template.parser.ast.AstTemplate;
import jetbrick.template.resolver.macro.MacroResolver;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretContextImpl;
import jetbrick.template.runtime.InterpretException;
import jetbrick.template.runtime.JetWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JetTemplateImpl
implements JetTemplate {
    private static final Logger log = LoggerFactory.getLogger(JetTemplateImpl.class);
    private final JetEngine engine;
    private final Resource resource;
    private final JetConfig config;
    private final JetSecurityManager securityManager;
    private final boolean reloadable;
    private volatile long lastModified;
    private Source source;
    private AstTemplate astNode;
    private JetTemplateOption option;
    private final MacroResolver macroResolver;

    public JetTemplateImpl(JetEngine engine, Resource resource, boolean reloadable, JetSecurityManager securityManager) {
        this.engine = engine;
        this.resource = resource;
        this.securityManager = securityManager;
        this.config = engine.getConfig();
        this.reloadable = reloadable;
        this.lastModified = 0L;
        this.macroResolver = new MacroResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() throws ResourceNotFoundException {
        if (!this.reloadable && this.lastModified > 0L) {
            return;
        }
        long ts = this.resource.lastModified();
        if (ts <= 0L) {
            throw new ResourceNotFoundException(this.resource.getRelativePathName());
        }
        if (this.lastModified != ts) {
            JetTemplateImpl jetTemplateImpl = this;
            synchronized (jetTemplateImpl) {
                ts = this.resource.lastModified();
                if (this.lastModified != ts) {
                    this.rebuildAstNodeAndConfig();
                    this.lastModified = ts;
                }
            }
        }
    }

    private void rebuildAstNodeAndConfig() {
        List<String> files;
        String filename = this.resource.getRelativePathName();
        char[] contents = this.resource.toCharArray(this.config.getInputEncoding());
        this.source = new Source(filename, contents);
        log.info("Loading template: {}", (Object)filename);
        ParserContext ctx = new ParserContext(this.engine.getGlobalResolver(), this.engine.getGlobalContext());
        ctx.setStrict(this.config.isSyntaxStrict());
        ctx.setSafecall(this.config.isSyntaxSafecall());
        ctx.setTrimLeadingWhitespaces(this.config.isTrimLeadingWhitespaces());
        ctx.setTrimDirectiveWhitespaces(this.config.isTrimDirectiveWhitespaces());
        ctx.setTrimDirectiveComments(this.config.isTrimDirectiveComments());
        ctx.setTrimDirectiveCommentsPrefix(this.config.getTrimDirectiveCommentsPrefix());
        ctx.setTrimDirectiveCommentsSuffix(this.config.getTrimDirectiveCommentsSuffix());
        this.astNode = AstBuilder.create(this.source, ctx);
        this.option = new JetTemplateOption(ctx);
        this.macroResolver.clear();
        List<AstDirectiveMacro> macros = ctx.getDeclaredMacros();
        if (macros != null && macros.size() > 0) {
            for (AstDirectiveMacro macro : macros) {
                this.macroResolver.register(new JetTemplateMacro(this, macro));
            }
        }
        if ((files = ctx.getLoadMacroFiles()) != null && files.size() > 0) {
            for (String file : files) {
                JetTemplate t = this.engine.getTemplate(file);
                this.macroResolver.register(t);
            }
        }
    }

    @Override
    public void render(Map<String, Object> context, Writer out) {
        JetWriter writer = JetWriter.create(out, this.config.getOutputEncoding(), this.option.isTrimLeadingWhitespaces(), this.config.isIoSkiperrors());
        this.doInterpret(context, writer);
    }

    @Override
    public void render(Map<String, Object> context, OutputStream out) {
        JetWriter writer = JetWriter.create(out, this.config.getOutputEncoding(), this.option.isTrimLeadingWhitespaces(), this.config.isIoSkiperrors());
        this.doInterpret(context, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInterpret(Map<String, Object> context, JetWriter writer) {
        InterpretContextImpl last = (InterpretContextImpl)InterpretContext.current();
        try {
            InterpretContextImpl ctx = new InterpretContextImpl(this.engine, writer, context, this.securityManager);
            try {
                ctx.getTemplateStack().push(this);
                ctx.getValueStack().push(this.option.getSymbols(), null, true);
                this.astNode.execute(ctx);
                ctx.getValueStack().pop();
                ctx.getTemplateStack().pop();
            }
            catch (InterpretException e) {
                throw e.set(ctx.getSource());
            }
            finally {
                ctx.freeThreadLocal();
            }
        }
        finally {
            if (last != null) {
                last.setThreadLocal();
            }
        }
    }

    @Override
    public JetTemplateMacro resolveMacro(String name, Class<?>[] argumentTypes, boolean root) {
        JetTemplateMacro macro = this.macroResolver.resolve(name, argumentTypes, this.reloadable);
        if (macro == null && root) {
            macro = this.engine.getGlobalResolver().resolveMacro(name, argumentTypes, this.reloadable);
        }
        return macro;
    }

    @Override
    public String getName() {
        return this.resource.getRelativePathName();
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public boolean isReloadable() {
        return this.reloadable;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public JetTemplateOption getOption() {
        return this.option;
    }

    @Override
    public AstTemplate getAstNode() {
        return this.astNode;
    }

    @Override
    public JetEngine getEngine() {
        return this.engine;
    }

    @Override
    public JetSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public String toString() {
        return this.getName();
    }
}

