/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import jetbrick.template.JetTemplate;
import jetbrick.template.JetTemplateMacro;
import jetbrick.template.parser.ast.AstDirective;
import jetbrick.template.parser.ast.AstExpressionList;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.resolver.ParameterUtils;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;
import jetbrick.util.ArrayUtils;

public final class AstDirectiveCall
extends AstDirective {
    private final String name;
    private final AstExpressionList argumentList;
    private JetTemplateMacro last;

    public AstDirectiveCall(String name, AstExpressionList argumentList, Position position) {
        super(position);
        this.name = name;
        this.argumentList = argumentList;
    }

    @Override
    public void execute(InterpretContext ctx) throws InterpretException {
        Object[] arguments = this.argumentList == null ? ArrayUtils.EMPTY_OBJECT_ARRAY : this.argumentList.execute(ctx);
        JetTemplateMacro macro = this.last;
        JetTemplate template = ctx.getTemplate();
        if (macro == null || template.isReloadable()) {
            Class<?>[] argumentTypes = ParameterUtils.getParameterTypes(arguments);
            macro = template.resolveMacro(this.name, argumentTypes, true);
            if (macro == null) {
                throw new InterpretException("cannot resolve macro: %s", this.name).set(this.position);
            }
            this.last = macro;
        }
        ctx.doMacroCall(macro, arguments);
    }
}

