/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import jetbrick.template.parser.ast.ALU;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;

public final class AstOperatorBinary
extends AstExpression {
    private final int operator;
    private final AstExpression lhs;
    private final AstExpression rhs;

    public AstOperatorBinary(int operator, AstExpression lhs, AstExpression rhs, Position position) {
        super(position);
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public Object execute(InterpretContext ctx) throws InterpretException {
        Object o1 = this.lhs.execute(ctx);
        Object o2 = this.rhs.execute(ctx);
        if (o1 == null) {
            if (o2 instanceof String && this.operator == 1) {
                return o2;
            }
            throw new InterpretException("left operand is null").set(this.lhs.getPosition());
        }
        if (o2 == null) {
            if (o1 instanceof String && this.operator == 1) {
                return o1;
            }
            throw new InterpretException("right operand is null").set(this.rhs.getPosition());
        }
        try {
            Object value;
            switch (this.operator) {
                case 1: {
                    value = ALU.plus(o1, o2);
                    break;
                }
                case 2: {
                    value = ALU.minus(o1, o2);
                    break;
                }
                case 3: {
                    value = ALU.mul(o1, o2);
                    break;
                }
                case 4: {
                    value = ALU.div(o1, o2);
                    break;
                }
                case 5: {
                    value = ALU.mod(o1, o2);
                    break;
                }
                case 6: {
                    value = ALU.bitAnd(o1, o2);
                    break;
                }
                case 7: {
                    value = ALU.bitOr(o1, o2);
                    break;
                }
                case 8: {
                    value = ALU.bitXor(o1, o2);
                    break;
                }
                case 9: {
                    value = ALU.shl(o1, o2);
                    break;
                }
                case 10: {
                    value = ALU.shr(o1, o2);
                    break;
                }
                case 11: {
                    value = ALU.ushr(o1, o2);
                    break;
                }
                case 12: {
                    value = ALU.lt(o1, o2);
                    break;
                }
                case 13: {
                    value = ALU.le(o1, o2);
                    break;
                }
                case 14: {
                    value = ALU.gt(o1, o2);
                    break;
                }
                case 15: {
                    value = ALU.ge(o1, o2);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return value;
        }
        catch (IllegalStateException e) {
            throw new InterpretException(e).set(this.position);
        }
    }
}

