/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import jetbrick.template.parser.ast.ALU;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;

public final class AstOperatorUnary
extends AstExpression {
    private final int operator;
    private final AstExpression expression;

    public AstOperatorUnary(int operator, AstExpression expression, Position position) {
        super(position);
        this.operator = operator;
        this.expression = expression;
    }

    @Override
    public Object execute(InterpretContext ctx) throws InterpretException {
        Object o = this.expression.execute(ctx);
        if (o == null) {
            throw new InterpretException("object is null").set(this.expression.getPosition());
        }
        try {
            Object value;
            switch (this.operator) {
                case 1: {
                    value = ALU.positive(o);
                    break;
                }
                case 2: {
                    value = ALU.negative(o);
                    break;
                }
                case 22: {
                    value = ALU.bitNot(o);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return value;
        }
        catch (IllegalStateException e) {
            throw new InterpretException(e).set(this.position);
        }
    }
}

