/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.resolver;

import java.lang.reflect.Array;
import jetbrick.util.ArrayUtils;

public final class ParameterUtils {
    public static Class<?>[] getParameterTypes(Object[] arguments) {
        Class[] argumentsTypes;
        int length = arguments.length;
        if (length == 0) {
            argumentsTypes = ArrayUtils.EMPTY_CLASS_ARRAY;
        } else {
            argumentsTypes = new Class[length];
            for (int i = 0; i < length; ++i) {
                Object object = arguments[i];
                argumentsTypes[i] = object == null ? null : object.getClass();
            }
        }
        return argumentsTypes;
    }

    public static Object[] getActualArguments(Object[] arguments, int actualLength, Class<?> varArgsClass, int offset) {
        if (varArgsClass != null) {
            int varArgsLen;
            Object[] args = new Object[actualLength];
            int fixedArgsLen = actualLength - offset - 1;
            if (fixedArgsLen > 0) {
                System.arraycopy(arguments, 0, args, offset, fixedArgsLen);
            }
            if ((varArgsLen = arguments.length - fixedArgsLen) == 0) {
                args[actualLength - 1] = Array.newInstance(varArgsClass, 0);
            } else {
                Object varArgs = null;
                if (varArgsLen == 1) {
                    Object arg = arguments[fixedArgsLen];
                    if (arg == null) {
                        varArgs = Array.newInstance(varArgsClass, 0);
                    } else if (Object[].class.isAssignableFrom(arg.getClass())) {
                        varArgs = arg;
                    }
                }
                if (varArgs == null) {
                    varArgs = Array.newInstance(varArgsClass, varArgsLen);
                    System.arraycopy(arguments, fixedArgsLen, varArgs, 0, varArgsLen);
                }
                args[actualLength - 1] = varArgs;
            }
            return args;
        }
        if (offset > 0) {
            Object[] args = new Object[actualLength];
            int length = actualLength - offset;
            if (length > 0) {
                System.arraycopy(arguments, 0, args, offset, length);
            }
            return args;
        }
        return arguments;
    }
}

