/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.resolver.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jetbrick.bean.ExecutableUtils;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.MethodInfo;
import jetbrick.template.JetAnnotations;
import jetbrick.template.resolver.SignatureUtils;
import jetbrick.template.resolver.function.ExtensionFunctionInvoker;
import jetbrick.template.resolver.function.FunctionInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FunctionInvokerResolver {
    private static final Logger log = LoggerFactory.getLogger(FunctionInvokerResolver.class);
    private final ConcurrentMap<String, FunctionInvoker> cache = new ConcurrentHashMap<String, FunctionInvoker>(64);
    private final Map<String, List<MethodInfo>> functionMap = new HashMap<String, List<MethodInfo>>(32);

    public void register(Class<?> cls) {
        KlassInfo klass = KlassInfo.create(cls);
        int i = 0;
        for (MethodInfo method : klass.getDeclaredMethods()) {
            if (!method.isStatic() || !method.isPublic()) continue;
            this.register(method);
            ++i;
        }
        log.info("import {} functions from {}", (Object)i, cls);
    }

    public void register(MethodInfo method) {
        List<MethodInfo> methods;
        String name = method.getName();
        JetAnnotations.Name rename = method.getMethod().getAnnotation(JetAnnotations.Name.class);
        if (rename != null && !"".equals(rename.value())) {
            name = rename.value();
        }
        if (log.isInfoEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(name).append('(');
            Class[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(parameterTypes[i].getName());
            }
            sb.append(')');
            log.debug("import function: {}", (Object)sb.toString());
        }
        if ((methods = this.functionMap.get(name)) == null) {
            methods = new ArrayList<MethodInfo>(4);
            this.functionMap.put(name, methods);
        }
        methods.add(method);
    }

    public FunctionInvoker resolve(String name, Class<?>[] argumentTypes) {
        String signature = SignatureUtils.getFunctionSignature(name, argumentTypes);
        FunctionInvoker found = (FunctionInvoker)this.cache.get(signature);
        if (found != null) {
            return found;
        }
        FunctionInvoker function = this.doGetFunctionInvoker(name, argumentTypes);
        if (function != null) {
            this.cache.put(signature, function);
            return function;
        }
        return null;
    }

    private FunctionInvoker doGetFunctionInvoker(String name, Class<?>[] argumentTypes) {
        MethodInfo function;
        List<MethodInfo> functions = this.functionMap.get(name);
        if (functions != null && (function = (MethodInfo)ExecutableUtils.searchExecutable(functions, null, (Class[])argumentTypes)) != null) {
            return new ExtensionFunctionInvoker(function);
        }
        return null;
    }
}

