/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.resolver.macro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrick.template.Errors;
import jetbrick.template.JetTemplate;
import jetbrick.template.JetTemplateMacro;

public final class MacroResolver {
    private List<JetTemplate> loadedTemplates;
    private Map<String, JetTemplateMacro> decleardMacros;
    private long lastCheckTimestamp = 0L;

    public void clear() {
        this.loadedTemplates = null;
        this.decleardMacros = null;
    }

    public void register(JetTemplate template) {
        if (this.loadedTemplates == null) {
            this.loadedTemplates = new ArrayList<JetTemplate>(4);
        }
        this.loadedTemplates.add(template);
    }

    public void register(JetTemplateMacro macro) {
        JetTemplateMacro old;
        if (this.decleardMacros == null) {
            this.decleardMacros = new HashMap<String, JetTemplateMacro>();
        }
        if ((old = this.decleardMacros.put(macro.getName(), macro)) != null) {
            throw new IllegalStateException(Errors.format("duplicated macro name: %s", macro.getName()));
        }
    }

    public JetTemplateMacro resolve(String name, Class<?>[] argumentTypes, boolean reloadable) {
        JetTemplateMacro macro;
        if (this.decleardMacros != null && (macro = this.decleardMacros.get(name)) != null) {
            return macro;
        }
        if (this.loadedTemplates != null) {
            if (reloadable) {
                this.checkImportedMacrosReload();
            }
            for (JetTemplate template : this.loadedTemplates) {
                macro = template.resolveMacro(name, argumentTypes, false);
                if (macro == null) continue;
                return macro;
            }
        }
        return null;
    }

    private void checkImportedMacrosReload() {
        long now = System.currentTimeMillis();
        if (now - this.lastCheckTimestamp > 5000L) {
            for (JetTemplate template : this.loadedTemplates) {
                template.reload();
            }
            this.lastCheckTimestamp = now;
        }
    }
}

