/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.runtime;

import java.io.Writer;
import jetbrick.io.stream.UnsafeCharArrayWriter;
import jetbrick.template.JetEngine;
import jetbrick.template.parser.ast.AstStatementList;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.JetWriter;
import jetbrick.template.runtime.ValueStack;

public final class JetTagContext {
    private final AstStatementList statements;

    public JetTagContext(AstStatementList statements) {
        this.statements = statements;
    }

    public String getBodyContent() {
        if (this.statements == null) {
            return "";
        }
        InterpretContext ctx = this.getInterpretContext();
        JetWriter originWriter = ctx.getWriter();
        UnsafeCharArrayWriter out = new UnsafeCharArrayWriter(128);
        JetWriter writer = JetWriter.create((Writer)out, originWriter.getCharset(), false, false);
        ctx.setWriter(writer);
        this.statements.execute(ctx);
        ctx.setWriter(originWriter);
        return out.toString();
    }

    public void invoke() {
        if (this.statements != null) {
            InterpretContext ctx = this.getInterpretContext();
            this.statements.execute(ctx);
        }
    }

    public InterpretContext getInterpretContext() {
        return InterpretContext.current();
    }

    public JetEngine getEngine() {
        return this.getInterpretContext().getEngine();
    }

    public JetWriter getWriter() {
        return this.getInterpretContext().getWriter();
    }

    public ValueStack getValueStack() {
        return this.getInterpretContext().getValueStack();
    }
}

