/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.runtime.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import jetbrick.template.runtime.JetWriter;

public final class JetOutputStreamPrinter
extends JetWriter {
    private final OutputStream os;
    private final Charset charset;
    private boolean error;

    public JetOutputStreamPrinter(OutputStream os, Charset charset) {
        this.os = os;
        this.charset = charset;
        this.error = false;
    }

    @Override
    public Object getOriginStream() {
        return this.os;
    }

    @Override
    public boolean isStreaming() {
        return true;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public boolean isSkipErrors() {
        return true;
    }

    @Override
    public void print(int x) {
        if (this.error) {
            return;
        }
        try {
            this.os.write(x);
        }
        catch (IOException e) {
            this.error = true;
        }
    }

    @Override
    public void print(byte[] x) {
        if (x != null) {
            if (this.error) {
                return;
            }
            try {
                this.os.write(x);
            }
            catch (IOException e) {
                this.error = true;
            }
        }
    }

    @Override
    public void print(byte[] x, int offset, int length) {
        if (x != null) {
            if (this.error) {
                return;
            }
            try {
                this.os.write(x, offset, length);
            }
            catch (IOException e) {
                this.error = true;
            }
        }
    }

    @Override
    public void print(char[] x) {
        if (x != null) {
            if (this.error) {
                return;
            }
            try {
                this.os.write(new String(x).getBytes(this.charset));
            }
            catch (IOException e) {
                this.error = true;
            }
        }
    }

    @Override
    public void print(char[] x, int offset, int length) {
        if (x != null) {
            if (this.error) {
                return;
            }
            try {
                this.os.write(new String(x, offset, length).getBytes(this.charset));
            }
            catch (IOException e) {
                this.error = true;
            }
        }
    }

    @Override
    public void print(String x) {
        if (x != null) {
            if (this.error) {
                return;
            }
            try {
                this.os.write(x.getBytes(this.charset));
            }
            catch (IOException e) {
                this.error = true;
            }
        }
    }

    @Override
    public void flush() {
        if (this.error) {
            return;
        }
        try {
            this.os.flush();
        }
        catch (IOException e) {
            this.error = true;
        }
    }

    @Override
    public void close() {
        if (this.error) {
            return;
        }
        try {
            this.os.close();
        }
        catch (IOException e) {
            this.error = true;
        }
    }
}

