/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.runtime.writer;

import java.io.IOException;
import java.io.Writer;
import jetbrick.template.runtime.OriginalStream;

public final class TrimLeadingWhitespacesWriter
extends Writer
implements OriginalStream {
    private final Writer out;
    private boolean first;

    public TrimLeadingWhitespacesWriter(Writer out) {
        this.out = out;
        this.first = true;
    }

    @Override
    public Object getOriginStream() {
        return this.out;
    }

    @Override
    public void write(int c) throws IOException {
        if (this.first) {
            if (c <= 32) {
                return;
            }
            this.first = false;
        }
        this.out.write(c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.first) {
            if ((off | len | cbuf.length - (len + off) | off + len) < 0) {
                throw new IndexOutOfBoundsException();
            }
            int max = off + len;
            while (off < max) {
                if (cbuf[off] <= ' ') {
                    ++off;
                    continue;
                }
                this.first = false;
                break;
            }
            if ((len = max - off) == 0) {
                return;
            }
        }
        this.out.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

