/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.aop.EncryptablePropertySourceMethodInterceptor;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptableEnumerablePropertySourceWrapper;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptableMapPropertySourceWrapper;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptablePropertySourceWrapper;
import java.util.stream.Stream;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.core.env.CommandLinePropertySource;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class EncryptablePropertySourceConverter {
    public static <T> PropertySource<T> proxyPropertySource(PropertySource<T> propertySource, EncryptablePropertyResolver resolver) {
        if (CommandLinePropertySource.class.isAssignableFrom(propertySource.getClass())) {
            return EncryptablePropertySourceConverter.instantiatePropertySource(propertySource, resolver);
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetClass(propertySource.getClass());
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.addInterface(EncryptablePropertySource.class);
        proxyFactory.setTarget(propertySource);
        proxyFactory.addAdvice(new EncryptablePropertySourceMethodInterceptor<T>(propertySource, resolver));
        return (PropertySource)proxyFactory.getProxy();
    }

    public static <T> PropertySource<T> instantiatePropertySource(PropertySource<T> propertySource, EncryptablePropertyResolver resolver) {
        Object encryptablePropertySource = EncryptablePropertySourceConverter.needsProxyAnyway(propertySource) ? EncryptablePropertySourceConverter.proxyPropertySource(propertySource, resolver) : (propertySource instanceof MapPropertySource ? new EncryptableMapPropertySourceWrapper((MapPropertySource)propertySource, resolver) : (propertySource instanceof EnumerablePropertySource ? new EncryptableEnumerablePropertySourceWrapper((EnumerablePropertySource)propertySource, resolver) : new EncryptablePropertySourceWrapper<T>(propertySource, resolver)));
        return encryptablePropertySource;
    }

    private static boolean needsProxyAnyway(PropertySource<?> ps) {
        return EncryptablePropertySourceConverter.needsProxyAnyway(ps.getClass());
    }

    private static boolean needsProxyAnyway(Class<? extends PropertySource<?>> psClass) {
        return EncryptablePropertySourceConverter.needsProxyAnyway(psClass.getName());
    }

    private static boolean needsProxyAnyway(String className) {
        return Stream.of("org.springframework.boot.context.config.ConfigFileApplicationListener$ConfigurationPropertySources", "org.springframework.boot.context.properties.source.ConfigurationPropertySourcesPropertySource").anyMatch(className::equals);
    }
}

