/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaour.api_scanner.config;

import com.github.xiaour.api_scanner.annotation.SapiGroup;
import com.github.xiaour.api_scanner.config.ApiServerAutoConfigure;
import com.github.xiaour.api_scanner.config.SapiGroupManager;
import com.github.xiaour.api_scanner.dto.ApiField;
import com.github.xiaour.api_scanner.dto.ApiInfo;
import com.github.xiaour.api_scanner.logging.Log;
import com.github.xiaour.api_scanner.logging.LogFactory;
import com.github.xiaour.api_scanner.util.ClassScaner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Configuration
@AutoConfigureBefore(value={ApiServerAutoConfigure.class})
@EnableConfigurationProperties(value={ApiServerAutoConfigure.class})
@ConfigurationProperties(value="spring.sapi")
public class SapiFactoryAutoConfigure
implements ImportBeanDefinitionRegistrar {
    private static final Log LOG = LogFactory.getLog(SapiFactoryAutoConfigure.class);
    private String pack;
    private String enable;
    public static List<ApiInfo> simpleApiList;
    private static String allRequestType;
    private static String annotationName;

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        boolean enabled;
        String[] values;
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)annotationMetadata.getAnnotationAttributes(annotationName));
        if (this.getPack() != null) {
            values = this.getPack().split(",");
            enabled = StringUtils.hasText((String)this.getEnable()) ? Boolean.getBoolean(this.getEnable()) : true;
        } else {
            values = attributes.getStringArray("controllers");
            enabled = attributes.getBoolean("enable");
        }
        if (enabled) {
            if (values != null) {
                this.init(values);
            } else {
                LOG.error("Sapi annotations not config,Please Configured the Application class @Sapi(controllers={\"your.controller.path1\",\"...\"})");
            }
        }
    }

    public void init(String[] controllers) {
        LOG.debug("Springboot SAPI init.");
        HashSet<Class> classes = new HashSet<Class>();
        try {
            for (String packageName : controllers) {
                classes.addAll(ClassScaner.scan(packageName, new Class[0]));
            }
            ArrayList<ApiInfo> list = new ArrayList<ApiInfo>();
            for (Class c : classes) {
                RequestMapping requestMapping = c.getAnnotation(RequestMapping.class);
                SapiGroup sapiGroup = c.getAnnotation(SapiGroup.class);
                String groupTitle = sapiGroup == null ? c.getSimpleName() : sapiGroup.title();
                SapiGroupManager.setSapiGroup(groupTitle);
                if (requestMapping == null) {
                    list.addAll(this.getReflectAllMethod(c, new String[]{""}, groupTitle));
                    continue;
                }
                list.addAll(this.getReflectAllMethod(c, requestMapping.value(), groupTitle));
            }
            simpleApiList = list;
        }
        catch (Exception e) {
            LOG.error("SAPI init exception:", e);
        }
    }

    private List<ApiInfo> getReflectAllMethod(Class<?> mLocalClass, String[] routes, String groupTitle) {
        LocalVariableTableParameterNameDiscoverer pnd = new LocalVariableTableParameterNameDiscoverer();
        ArrayList<ApiInfo> list = new ArrayList<ApiInfo>();
        try {
            do {
                Method[] methods;
                for (Method method : methods = mLocalClass.getDeclaredMethods()) {
                    Class<?>[] paramsTypes = method.getParameterTypes();
                    Annotation[][] paramAnnotations = method.getParameterAnnotations();
                    int length = paramsTypes.length;
                    for (String route : routes) {
                        String mod = Modifier.toString(method.getModifiers());
                        String metName = method.getName();
                        RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
                        if (!mod.equals("public") || metName.equals("toString") || metName.equals("equals")) continue;
                        if (requestMapping != null) {
                            for (String mappingName : requestMapping.value()) {
                                RequestMethod[] me;
                                String requestInfo = "";
                                for (RequestMethod rm : me = method.getAnnotation(RequestMapping.class).method()) {
                                    requestInfo = rm.name();
                                }
                                if (requestInfo == "") {
                                    requestInfo = allRequestType;
                                }
                                ApiInfo apiInfo = SapiFactoryAutoConfigure.getApiInfo(method, route, mappingName, (ParameterNameDiscoverer)pnd, length, paramsTypes, requestInfo, paramAnnotations);
                                apiInfo.setGroupTitle(groupTitle);
                                list.add(apiInfo);
                            }
                            continue;
                        }
                        OtherMapping otherMapping = SapiFactoryAutoConfigure.getMappingType(method);
                        if (otherMapping == null) continue;
                        for (String mappingName : otherMapping.getMappingName()) {
                            ApiInfo apiInfo = SapiFactoryAutoConfigure.getApiInfo(method, route, mappingName, (ParameterNameDiscoverer)pnd, length, paramsTypes, otherMapping.getRequestType(), paramAnnotations);
                            apiInfo.setGroupTitle(groupTitle);
                            list.add(apiInfo);
                        }
                    }
                }
            } while ((mLocalClass = mLocalClass.getSuperclass()) != null);
        }
        catch (Exception e) {
            LOG.error("Sapi init exception:", e);
        }
        return list;
    }

    private static ApiInfo getApiInfo(Method method, String route, String mappingName, ParameterNameDiscoverer pnd, int length, Class<?>[] paramsTypes, String requestType, Annotation[][] paramAnnotations) {
        ApiInfo apiInfo = new ApiInfo();
        if (requestType != null) {
            apiInfo.setRequestType(requestType);
        }
        apiInfo.setUrl(route + "/" + mappingName);
        apiInfo.setUrl(apiInfo.getUrl().replaceAll("//", "/"));
        String[] paramNames = pnd.getParameterNames(method);
        List<ApiField> apiFields = SapiFactoryAutoConfigure.getDefaultType(length, paramsTypes, paramNames, paramAnnotations);
        apiInfo.setFieldList(apiFields);
        apiInfo.setId();
        return apiInfo;
    }

    private static OtherMapping getMappingType(Method method) {
        OtherMapping otherMapping = new OtherMapping();
        PostMapping postMapping = method.getAnnotation(PostMapping.class);
        GetMapping getMapping = method.getAnnotation(GetMapping.class);
        DeleteMapping deleteMapping = method.getAnnotation(DeleteMapping.class);
        PatchMapping patchMapping = method.getAnnotation(PatchMapping.class);
        PutMapping putMapping = method.getAnnotation(PutMapping.class);
        if (postMapping != null) {
            otherMapping.setMappingName(postMapping.value());
            otherMapping.setRequestType(RequestMethod.POST.name());
            return otherMapping;
        }
        if (getMapping != null) {
            otherMapping.setMappingName(getMapping.value());
            otherMapping.setRequestType(RequestMethod.GET.name());
            return otherMapping;
        }
        if (deleteMapping != null) {
            otherMapping.setMappingName(deleteMapping.value());
            otherMapping.setRequestType(RequestMethod.DELETE.name());
            return otherMapping;
        }
        if (patchMapping != null) {
            otherMapping.setMappingName(patchMapping.value());
            otherMapping.setRequestType(RequestMethod.PATCH.name());
            return otherMapping;
        }
        if (putMapping != null) {
            otherMapping.setMappingName(putMapping.value());
            otherMapping.setRequestType(RequestMethod.PUT.name());
            return otherMapping;
        }
        return null;
    }

    private static boolean isJavaClass(Class<?> clz) {
        if (clz.getName().contains("multipart.MultipartFile")) {
            return true;
        }
        return clz != null && clz.getClassLoader() == null;
    }

    private static List<ApiField> getDefaultType(int length, Class<?>[] paramsTypes, String[] paramNames, Annotation[][] paramAnnotations) {
        ArrayList<ApiField> apiFields = new ArrayList<ApiField>(length);
        for (int i = 0; i < length; ++i) {
            if (paramsTypes[i].getName().contains("javax.servlet.")) continue;
            if (SapiFactoryAutoConfigure.isJavaClass(paramsTypes[i])) {
                Annotation[] annotations;
                ApiField apiField = new ApiField();
                String type = SapiFactoryAutoConfigure.getTypeName(paramsTypes[i].toString());
                apiField.setName(paramNames[i]);
                apiField.setType(type);
                for (Annotation annotation : annotations = paramAnnotations[i]) {
                    if (annotation.annotationType().getSimpleName().equals("PathVariable")) {
                        apiField.setIsPath(true);
                        break;
                    }
                    if (!annotation.annotationType().getSimpleName().equals("RequestBody")) continue;
                    apiField.setRequestBody(true);
                    break;
                }
                apiFields.add(apiField);
                continue;
            }
            SapiFactoryAutoConfigure.getCustomType(paramsTypes[i], apiFields);
        }
        return apiFields;
    }

    private static void getCustomType(Class clz, List<ApiField> apiFields) {
        try {
            Field[] fields;
            for (Field f : fields = clz.getDeclaredFields()) {
                ApiField apiField = new ApiField();
                apiField.setName(f.getName());
                apiField.setType(SapiFactoryAutoConfigure.getTypeName(f.getType().getName()));
                apiFields.add(apiField);
            }
        }
        catch (Exception e) {
            LOG.error("Sapi getCustomType exception:", e);
        }
    }

    private static String getTypeName(String typeName) {
        return typeName.toString().substring(typeName.toString().lastIndexOf(".") + 1, typeName.toString().length());
    }

    public String getPack() {
        return this.pack;
    }

    public void setPack(String pack) {
        this.pack = pack;
    }

    public String getEnable() {
        return this.enable;
    }

    public void setEnable(String enable) {
        this.enable = enable;
    }

    static {
        allRequestType = "POST,GET,PUT,DELETE,PATCH";
        annotationName = "com.github.xiaour.api_scanner.annotation.Sapi";
    }

    static class OtherMapping {
        private String[] mappingName;
        private String requestType;

        OtherMapping() {
        }

        public String[] getMappingName() {
            return this.mappingName;
        }

        public void setMappingName(String[] mappingName) {
            this.mappingName = mappingName;
        }

        public String getRequestType() {
            return this.requestType;
        }

        public void setRequestType(String requestType) {
            this.requestType = requestType;
        }
    }
}

