/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaour.api_scanner.servlet;

import com.github.xiaour.api_scanner.config.ApiServerAutoConfigure;
import com.github.xiaour.api_scanner.logging.Log;
import com.github.xiaour.api_scanner.logging.LogFactory;
import com.github.xiaour.api_scanner.util.Utils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@WebServlet(name="ApiViewServlet", urlPatterns={"/sapi/*"})
@ConditionalOnProperty(name={"spring.sapi.enable"}, havingValue="true", matchIfMissing=true)
public class ApiViewServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(ApiViewServlet.class);
    protected final String resourcePath;

    public ApiViewServlet() {
        this.resourcePath = "support/http";
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json;charset=utf-8");
        resp.setCharacterEncoding("UTF-8");
        String url = req.getRequestURI();
        if (url.equals(ApiServerAutoConfigure.getContextPath() + "/sapi/list".replaceAll("//", "/"))) {
            this.list(req, resp);
        } else {
            this.index(req, resp);
        }
    }

    private void list(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        response.setCharacterEncoding("utf-8");
        if (contextPath == null) {
            contextPath = "";
        }
        String uri = contextPath + servletPath;
        String path = "/list.html";
        try {
            this.returnResourceFile(path, uri, response);
        }
        catch (ServletException e) {
            LOG.error("Sapi init exception:", e);
        }
    }

    private void index(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String requestURI = request.getRequestURI();
        response.setCharacterEncoding("utf-8");
        if (contextPath == null) {
            contextPath = "";
        }
        String uri = contextPath + servletPath;
        String path = requestURI.substring(contextPath.length() + servletPath.length());
        if ("/".equals(path) || "".equals(path)) {
            path = "/index.html";
        }
        try {
            this.returnResourceFile(path, uri, response);
        }
        catch (ServletException e) {
            LOG.error("Sapi init exception:", e);
        }
    }

    protected void returnResourceFile(String fileName, String uri, HttpServletResponse response) throws ServletException, IOException {
        String filePath = this.getFilePath(fileName);
        if (filePath.endsWith(".html")) {
            response.setContentType("text/html; charset=utf-8");
        }
        if (fileName.endsWith(".jpg")) {
            byte[] bytes = Utils.readByteArrayFromResource(filePath);
            if (bytes != null) {
                response.getOutputStream().write(bytes);
            }
            return;
        }
        String text = Utils.readFromResource(filePath);
        if (text == null) {
            response.sendRedirect(uri + "/index.html");
            return;
        }
        if (fileName.endsWith(".css")) {
            response.setContentType("text/css;charset=utf-8");
        } else if (fileName.endsWith(".js")) {
            response.setContentType("text/javascript;charset=utf-8");
        }
        response.getWriter().write(text);
    }

    protected String getFilePath(String fileName) {
        return this.resourcePath + fileName;
    }
}

